/*******************************************************************************
 * Copyright (C) 2016 Maxim Integrated Products, Inc., All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL MAXIM INTEGRATED BE LIABLE FOR ANY CLAIM, DAMAGES
 * OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 *
 * Except as contained in this notice, the name of Maxim Integrated
 * Products, Inc. shall not be used except as stated in the Maxim Integrated
 * Products, Inc. Branding Policy.
 *
 * The mere transfer of this software does not imply any licenses
 * of trade secrets, proprietary technology, copyrights, patents,
 * trademarks, maskwork rights, or any other form of intellectual
 * property whatsoever. Maxim Integrated Products, Inc. retains all
 * ownership rights.
 *
 * $Date: 2016-04-27 15:26:08 -0500 (Wed, 27 Apr 2016) $
 * $Revision: 22543 $
 *
 ******************************************************************************/

#include <stddef.h>
#include "mxc_config.h"
#include "ioman.h"

/******************************************************************************/
int IOMAN_Config(const ioman_cfg_t *cfg)
{
    if(cfg == NULL) {
        return E_NULL_PTR;
    }

    if (*cfg->ack_reg != cfg->req_val.value) {
        /* Request pin mapping */
        *cfg->req_reg = cfg->req_val.value;

        /* Check for acknowledgment */
        if (*cfg->ack_reg != cfg->req_val.value) {
            return E_BUSY;
        }
    }

    return E_NO_ERROR;
}


ioman_cfg_t IOMAN_SPIS(int map_req, int io_en, int quad, int fast) {
	ioman_cfg_t cfg;

	cfg.req_reg = &MXC_IOMAN->spis_req;
	cfg.ack_reg = &MXC_IOMAN->spis_ack;

	mxc_ioman_spis_req_t spis_req = {0};
	spis_req.mapping_req = map_req;
	spis_req.core_io_req = io_en;
	spis_req.quad_io_req = quad;
	spis_req.fast_mode = fast;

	cfg.req_val.spis = spis_req;

	return cfg;
}

ioman_cfg_t IOMAN_SPIM2(ioman_map_t map, int io_en, int ss0, int ss1, int ss2, int sr0, int sr1, int quad, int fast) {
	ioman_cfg_t cfg;

	cfg.req_reg = &MXC_IOMAN->spim2_req;
	cfg.ack_reg = &MXC_IOMAN->spim2_ack;

	mxc_ioman_spim2_req_t spim2_req = {0};

	spim2_req.mapping_req = map;
	spim2_req.core_io_req = io_en;
	spim2_req.ss0_io_req = ss0;
	spim2_req.ss1_io_req = ss1;
	spim2_req.ss2_io_req = ss2;
	spim2_req.sr0_io_req = sr0;
	spim2_req.sr1_io_req = sr1;
	spim2_req.quad_io_req = quad;
	spim2_req.fast_mode = fast;
	cfg.req_val.spim2 = spim2_req;

	return cfg;

}
