/* 

Task1_FSM_Counter

Sample code from ELEC2645 Week 16 Lab

Demonstrates how to implement a simple FSM counter

(c) Bonny Ngangu, University of Leeds, Jan 2016

*/ 

#include "mbed.h"

// K64F on-board 4 LEDs 
DigitalOut r_led(LED_RED);
DigitalOut g_led(LED_GREEN);
DigitalOut b_led(LED_BLUE);
DigitalOut y_led(LED_BLUE);

// K64F on-board switches
InterruptIn sw2(SW2);
InterruptIn sw3(SW3);

// LEDs to display counter output
// connect up external LEDs to these pins with appropriate current-limiting resistor
BusOut output(PTB2,PTB3,PTB10,PTB11);

// array of states in the FSM, each element is the output of the counter
int fsm[4] = {8,4,2,1}; //reversed order counter going down

// function prototypes
// error function hangs flashing an LED
void error();
// set-up the on-board LEDs and switches
void init_K64F();

int main()
{
    init_K64F();
    // set inital state 
    int state = 0;

    while(1) {  // loop forever

        output = fsm[state];  // output current state

        // check which state we are in and see which the next state should be
        switch(state) {
            case 0://0
                state = 1;//1
                break;
            case 1://1
                state = 2;//2
                break;
            case 2://2
                state = 3;//3
                break;
            case 3://3
                state = 0;//0
                break;
            default:
                error();  //invalid state - call error routine
                // or could jump to starting state i.e. state = 0
                break;  
        }

        wait(0.2);  // small delay

    }
}

void init_K64F() 
{
    // on-board LEDs are active-low, so set pin high to turn them off.
    r_led = 1;
    g_led = 1;
    b_led = 1;
    y_led = 1;   
    
    // since the on-board switches have external pull-ups, we should disable the internal pull-down
    // resistors that are enabled by default using InterruptIn
    sw2.mode(PullNone);
    sw3.mode(PullNone);

}

void error()
{
    while(1) {  // if error, hang while flashing error message
        r_led = 0;
        wait(0.2);
        r_led = 1;
        wait(0.2);    
    }    
}