#ifndef MAIN_H
#define MAIN_H 

#include "mbed.h"
#include "N5110.h" /// to enable access and use of the N5110 classes.

#define DIRECTION_TOLERANCE 0.25 /// changing to this value enables altering tolerance of joystick direction

/**
@namespace Nokia 5110_lcd
@brief lcd display
*/
///          VCC,    SCE,  RST,    D/C,   MOSI,  SCLK,   LED
N5110 lcd (PTE26 , PTA0 , PTC4 , PTD0 , PTD2 , PTD1 , PTC3);
/// Can also power (VCC) directly from VOUT (3.3 V) -
/// Can give better performance due to current limitation from GPIO pin

/**
@namespace buzzer
@brief buzzer connection
*/
PwmOut buzzer(PTA2); /// buzzer connection to PwmOut.

/**
@namespace button
@brief button connection
*/
InterruptIn interrupt_button(PTB18); // interrupting the sleep mode.

/**
@namespace buttonjoystick
@brief buttonjoystick connection
*/
DigitalIn button(PTB10); /// connections for joystick

/**
@namespace xPot
@brief joystick movement in x-axis.
*/
AnalogIn xPot(PTB2); /// X-axisconnections for joystick

/**
@namespace yPot
@brief joystick movement in y-axis.
*/
AnalogIn yPot(PTB3); /// Y-axisconnections for joystick

Ticker pollJoystick;/// regular reading of the joystick position.

Serial serial(USBTX,USBRX);/// Serial for debug

/**
create enumerated type (0,1,2,3 etc. for direction)
could be extended for diagonals etc.
*/
enum DirectionName {
    UP,
    DOWN,
    LEFT,
    RIGHT,
    CENTRE,
    UNKNOWN
};

typedef struct JoyStick Joystick;// for Joystick structure

struct JoyStick {
    float x;    /// current x value
    float x0;   /// 'centred' x value
    float y;    /// current y value
    float y0;   /// 'centred' y value
    int buttonjoystick; /// button state (assume pull-down used, so 1 = pressed, 0 = unpressed)
    DirectionName direction;  /// current direction
};

Joystick joystick;/// creating struct variables

volatile int g_button_flag = 0;/// setting the "g_button_flag" original value to Zero.

/**
initialize the position of the joystick.
*/
// initialising joystick position.
void calibrateJoystick();

/**
read the current joystick value.
*/
// reading the current value of joystick .
void updateJoystick();

/**
return back button_isr value.
*/
void button_isr();

int status = 1;/// setting the status at the origin.
int printFlag = 0;/// this sets Flags value to Zero

#endif
