// PROGRAM'S LIBRARIES
#include "mbed.h"
#include "N5110.h"
#define PI 3.14159265359
#define CMD_DC_INVERT_VIDEO    0x0D

// VARIABLES DEFINED
#define WIDTH 84
#define HEIGH 48
#define BANKS 6

// mbed API OBJECTS
AnalogIn pot(p17); // DAC on pin 18 for analogue input to control the timer
DigitalIn button(p5); // SPI on pin 5 for digital input to control the radom distribution
DigitalIn stop(p6); // SPI on pin 6

// VCC,SCE,RST,D/C,MOSI,SCLK,LED
N5110 lcd(p7,p8,p9,p10,p11,p13,p21); // N5110 lcd pin connection
// VCC powered directly from VOUT (3.3 V) -
// Can give better performance due to current limitation from GPIO pin
BusOut myleds(LED4, LED3, LED2, LED1);// the LEDs are flashing in opposite direction - used as speed control

// GLOBAL VARIABLES
bool Cells[84][48];  // array to hold samples
int checkNeigbour  (int i, int j); // to check cell within the sample

// FUNCTION PROTOTYPES
void init();
void setPixel();
void displayNext();
void clearBuffer();
void gameSetUp();
void checkBoard();
void countkNeigbour  (int i, int j);// to count surrounding cells
void glider();
void turnOff();

// START OF MAIN()
int main()
{
    // INITIALISATION CODE
    lcd.init();
    //  drawing rectangles frame
    //  origin x,y,width,height,type
    lcd.drawRect(0,0,83,47,0);    // transparent, just outline rectangle
    lcd.refresh();
    // printing strings at specified co-ordinates
    lcd.printString("Hello, World!",6,3);
    // refreshing display after setting pixels
    lcd.refresh();
    wait(1);
    void clearCells();
    // loop throught cells, and clear
    for (int i = 1; i < 83 ; i++) {
        for (int j = 1; j < 47 ; j++) {
            lcd.clearPixel(i,j);
        }
    }
    lcd.refresh(); // refreshing lcd to write buffer to display

    lcd.printString("Welcome to",15,1); // splash screen
    lcd.printString("Conway's",20,2);
    lcd.printString("Game of Life",6,3);
    lcd.printString("Bonny Ngangu",6,4);
    // drawing a line across the display at y = 40 pixels (6 pixel offser from left, and toward right)
    for (int i = 6; i < 78; i++) {
        lcd.setPixel(i,40);
    }
    lcd.refresh(); // refreshing LCD after setting pixels
    wait(3);
    void clearCells();
    // loop throught cells, and clear
    for (int i = 1; i < 83 ; i++) {
        for (int j = 1; j < 47 ; j++) {
            lcd.clearPixel(i,j);
        }
    }
    lcd.refresh(); // refreshing to write buffer to display
    // printing strings at specified co-ordinates
    lcd.printString("Two!",20,2);
    // refreshing display after setting pixels
    lcd.refresh();
    wait(1);
    void clearCells();
    // loop throught cells, and clear
    for (int i = 1; i < 83 ; i++) {
        for (int j = 1; j < 47 ; j++) {
            lcd.clearPixel(i,j);
        }
    }
    lcd.refresh(); // refreshing to write buffer to display

    // printing strings at specified co-ordinates
    lcd.printString("One!",20,2);
    // need to refresh display after setting pixels
    lcd.refresh();
    wait(1);
    void clearCells();
    // loop throught cells, and clear
    for (int i = 1; i < 83 ; i++) {
        for (int j = 1; j < 47 ; j++) {
            lcd.clearPixel(i,j);
        }
    }
    lcd.refresh(); // refreshing to write buffer to display

    // printing strings at specified co-ordinates
    lcd.printString("Have Fun!",20,2);
    // need to refresh display after setting pixels
    lcd.refresh();
    wait(1);
    void clearCells();
    // loop throught cells, and clear
    for (int i = 1; i < 83 ; i++) {
        for (int j = 1; j < 47 ; j++) {
            lcd.clearPixel(i,j);
        }
    }
    lcd.refresh(); // refreshing to write buffer to display
    
    // TESTING USING GLIDER AND STRUCTRES
    glider(); // glicer testing
    lcd.refresh();
    wait(1);

    // INFINITE LOOP
    while(1) {
        displayNext();
        wait(pot);
        for(int i=0; i<16; i++) {
            myleds = i;
            wait(pot);
        }
    }
}
    
    // SURROUNDING LIVING CELLS CHECK
int checkNeigbour  (int i, int j)   // number of neighbours
{
    int n = 0; // number of neighbours

    if (lcd.getPixel(i-1,j-1)) // pixel to top-left
        n++;
    if (lcd.getPixel(i-1,j)) // pixel to left
        n++;
    if (lcd.getPixel(i-1,j+1)) // pixel to bottom-left
        n++;
    if (lcd.getPixel(i,j-1)) // pixel to top
        n++;
    if (lcd.getPixel(i,j+1)) // pixel to bottom
        n++;
    if (lcd.getPixel(i+1,j-1)) // pixel to top-right
        n++;
    if (lcd.getPixel(i+1,j)) // pixel to right
        n++;
    if (lcd.getPixel(i+1,j+1)) // pixel to bottom-right
        n++;
    return n;
}

/* APPLING RULES:
1.  Any live cell with fewer than two live neighbours dies, due to under-population.
2.  Any live cell with two or three live neighbours lives on to the next generation.
3.  Any live cell with more than three live neighbours dies, due to over-population.
4.  Any dead cell with exactly three live neighbours becomes a live cell, due to reproduction.*/

void gameSetUp() // appliying rules of the game
{
    for (int i = 0; i < 84 ; i++) {
        for (int j = 0; j < 48 ; j++) {
            int n = checkNeigbour(i,j);

            if (lcd.getPixel(i,j)) {// this means that if a pixel is already on
                if (n==2) // cell with 2 neighbours live on in the next generation
                    Cells[i][j]=1;
                else if (n==3) // cell with 3 neighbours live on in the next generation
                    Cells[i][j]=1;
                else if (n>3) // cell with > 3 neighbours dies - overpopulation
                    Cells[i][j]=0;
                else if (n<2) // cell with < 2 neighbours dies - underpopulation
                    Cells[i][j]=0;
            } else { // if no pixel is set on yet
                if (n==3) // cell with exactly 3 neighbours becomes alive - reproduction
                    Cells[i][j]=1; 
            }
        }
    }
    lcd.refresh();
}

// NEW GENERATION CELLS
void displayNext()
{
    gameSetUp();
    for (int i = 0; i < 84 ; i++) {
        for (int j = 0; j < 48 ; j++) {
            if (Cells[i][j]==1)
                lcd.setPixel(i,j);
            else
                lcd.clearPixel(i,j);
        }
    }
    
// RANDON CELLS DISTRIBUTION WHEN BUTTON A IS PRESSED AND HOLDED FOR 0.5 MS
    if(button==1) {
    lcd.randomiseBuffer();
    lcd.refresh();
    wait_ms(0.5);
    }
    
// TURNING OFF THE PROCESS
    if(stop==1) {
    lcd.turnOff();
    lcd.refresh();
    wait_ms(0.1);
    }
    }
void glider() // glider testing
{
    lcd.setPixel(17,17);
    wait(pot);
    lcd.setPixel(17,18);
    wait(pot);
    lcd.setPixel(17,19);
    wait(pot);
    lcd.setPixel(16,19);
    wait(pot);
    lcd.setPixel(15,18);
    wait(pot);
    }
    
    