/* 
 Joystick_Project
Bonny Ngangu
6 March 2016
(c) Bonny Ngangu, University of Leeds, Feb 2016

*/ 

#include "mbed.h"
// include the library header, ensure the library has been imported into the project
#include "TMP102.h"
#include "N5110.h"


//Joystick direction tolerance altering 
#define DIRECTION_TOLERANCE 0.1


// Create TMP102 object
TMP102 tmp102(I2C_SDA,I2C_SCL);  
// UART connection for PC
Serial pc(USBTX,USBRX);

// K64F on-board LEDs 
DigitalOut r_led(LED_RED);
DigitalOut g_led(LED_GREEN);
DigitalOut b_led(LED_BLUE);

//         VCC,    SCE,   RST,   D/C,   MOSI,  SCLK,   LED
N5110 lcd (PTE26 , PTA0 , PTC4 , PTD0 , PTD2 , PTD1 , PTC3);



// K64F on-board switches
InterruptIn sw2(SW2);
InterruptIn sw3(SW3);

// error function hangs flashing an LED
void error();
// setup serial port
void init_serial();
// set-up the on-board LEDs and switches
void init_K64F();

int main()
{
    // first need to initialise display
    lcd.init();
    // initialise the board and serial port
    init_K64F();
    init_serial(); 
    // call the sensor init method using dot syntax
    tmp102.init();
    
    while (1) {
        
        // these are default settings so not strictly needed
        lcd.normalMode();      // normal colour mode
        lcd.setBrightness(0.5); // put LED backlight on 50%

        // can directly print strings at specified co-ordinates
        lcd.printString("Current Temp",0,0);
        
        // read temperature and print over serial port
        float T = tmp102.get_temperature();
        pc.printf("T = %f K\n",T);
        
        char buffer[14];  // each character is 6 pixels wide, screen is 84 pixels (84/6 = 14)
        // so can display a string of a maximum 14 characters in length
        // or create formatted strings - ensure they aren't more than 14 characters long
        int length = sprintf(buffer,"T = %.2f C",T); // print formatted data to buffer
        // it is important the format specifier ensures the length will fit in the buffer
        if (length <= 14)  // if string will fit on display
            lcd.printString(buffer,0,2);
        
        // small delay - 1s to match the update rate of the sensor (1 Hz)
        wait(1.0);
        
        if(T<27){
            
            g_led = 0;
            lcd.printString("Fan OFF",0,4);
        }
        
        if (T>=30){
            
            r_led = 0;
            lcd.printString("Fan ON ",0,4);
       }

    }

}

void init_serial() {
    // set to highest baud - ensure terminal software matches
    pc.baud(115200); 
}

void init_K64F() 
{
    // on-board LEDs are active-low, so set pin high to turn them off.
    r_led = 1;
    g_led = 1;
    b_led = 1;   
    
    // since the on-board switches have external pull-ups, we should disable the internal pull-down
    // resistors that are enabled by default using InterruptIn
    sw2.mode(PullNone);
    sw3.mode(PullNone);
}
