/* 
 Joystick_Project
Bonny Ngangu
6 March 2016
(c) Bonny Ngangu, University of Leeds, Feb 2016

*/ 

#include "mbed.h"
// include the library header, ensure the library has been imported into the project
#include "TMP102.h"
#include "N5110.h"


// Create TMP102 object
TMP102 tmp102(I2C_SDA,I2C_SCL);  
// UART connection for PC
Serial pc(USBTX,USBRX);

// K64F on-board LEDs 
DigitalOut r_led(LED_RED);
DigitalOut g_led(LED_GREEN);
DigitalOut b_led(LED_BLUE);

// K64F on-board switches
InterruptIn sw2(SW2);
InterruptIn sw3(SW3);

// error function hangs flashing an LED
void error();
// setup serial port
void init_serial();
// set-up the on-board LEDs and switches
void init_K64F();
void printString();

void init_serial() {
    // set to highest baud - ensure terminal software matches
    pc.baud(115200); 
}

void init_K64F() 
{
    // on-board LEDs are active-low, so set pin high to turn them off.
    r_led = 1;
    g_led = 1;
    b_led = 1;   
    
    // since the on-board switches have external pull-ups, we should disable the internal pull-down
    // resistors that are enabled by default using InterruptIn
    sw2.mode(PullNone);
    sw3.mode(PullNone);
}