#ifndef MBED_EMMACODE_H
#define MBED_EMMACODE_H

#include "mbed.h"
#include "espduino.h"           //wifi mqtt
#include "mqtt.h"               //wifi mqtt
#include "rest.h"               //wifi rest
#include "MQTTClient.h"         //eth mqtt
#include "MQTTEthernet.h"       //eth mqtt
#include "MbedJSONValue.h"      //json
#include "SDFileSystem.h"       //sd card
#include "Crypto.h"             //hash calculation
#include "cmsis_os.h"           //threads
#include "ade7758.h"            //ade7758
#include "SPI_TFT_ILI9341.h"    //lcd
#include "Touch.h"              //touch
#include "Arial12x12.h"         //font
#include "SetRTC.h"             //rtc
#include "DHT11.h"              //dht11
#include <string>

//platform
#if defined TARGET_NUCLEO_F103RB
#define BASE_ADDR 0x1FFFF7E8
#elif defined TARGET_NUCLEO_F401RE
#define BASE_ADDR 0x1FFF7A10
#endif

#define MAXTOKEN                64

//mode
#define MODE_WIFI_CONFIG        0x00    //wifi config
#define MODE_SETTINGS           0x01    //settings
#define MODE_REGISTER           0x02    //registration
#define MODE_OPERATION          0x03    //operational
#define MODE_FIRMWARE_DOWNLOAD  0x04    //firmware download

//interface
#define IF_WIFI         0x00
#define IF_ETH          0x01
#define IF_GPRS         0x02

//wifi
#define ESP_BAUD    19200

//mqtt
#define MQTT_MAX_PACKET_SIZE    250 //for eth
#define MQTT_HOST               "192.168.131.200"
#define MQTT_PORT               1883

//eth rest
#define SERVER_PORT             80

//nodes and remote
#define REMOTE_TCP_PORT         16038
#define NODES_MAX               5
#define NODES_INVALID           99

//emma server
#define EMMA_SERVER_HOST        "192.168.131.200"
#define EMMA_SERVER_PORT        8080

//ade7758 offset
#define AIRMSOFFSET     0xFB1
#define BIRMSOFFSET     0xFB0
#define CIRMSOFFSET     0xFB1
#define AVRMSOFFSET     0xFFB
#define BVRMSOFFSET     0x2
#define CVRMSOFFSET     0xFFF

//threshold
#define VRMSTHRESHOLD   250
#define WATTTHRESHOLD   10000

/*start lcd and touch*/
int emmaModeSelection(void);
/*end lcd and touch*/

/*start emma mode*/
void emmaInit(int mode);
void emmaModeWiFiConfig(void);
void emmaModeSettings(void);
void emmaModeRegister(void);
void emmaModeOperation(void);
void emmaModeFirmwareDownload(void);
/*end emma mode*/

/*start energy related*/
void energyThread(void const*);
void checkVoltagePower(void);
/*end energy related*/

/*start wifi mqtt*/
void mqttConnected(void* response);
void mqttDisconnected(void* response);
/*end wifi mqtt*/

/*start wifi rest*/
void rxInterrupt(void);
void checkRxBuffer(void);
/*end wifi rest*/

/*start eth mqtt*/
int publish(MQTT::Client<MQTTEthernet, Countdown, MQTT_MAX_PACKET_SIZE>* client, MQTTEthernet* ipstack);
void ethMQTTMessageArrived(MQTT::MessageData& md);
int ethMQTTConnect(MQTT::Client<MQTTEthernet, Countdown, MQTT_MAX_PACKET_SIZE>* client, MQTTEthernet* ipstack);
void ethMQTTAttemptConnect(MQTT::Client<MQTTEthernet, Countdown, MQTT_MAX_PACKET_SIZE>* client, MQTTEthernet* ipstack);
/*end eth mqtt*/

/*start emma settings*/
string getUID(void);
string readSetting(string parameter);
bool writeSetting(string parameter, string value);
/*end emma settings*/

/*start nodes*/
string readNodeIP(string macAddr);
string readNodeCmd(string dType, string cmd);
string *readNodeList(void);
string wifiGetNodeTemp(string macAddr);
/*end nodes*/

/*start emma connection function*/
string ethGET(string host, int port, string data);
/*end emma connection function*/

/*start emma private function*/
//void connectedIface(void);
void isEthAvailable(void);
void isEthConnected(void);
void isWiFiConnected(void);
void isGprsConnected(void);
void addChar(char *s, char c);
void rcvReply(char *r, int to);
string calculateMD5(string text);
bool writeFirmwareHexToChar(string value);
bool clearFirmware(void);
/*end emma private function*/

#endif