#include "mbed.h"
#include "nmea_parser.hpp"

nmea_parser::nmea_parser(int rx_length, int sentence_length, Serial * uart)
{
  device = uart;
  rx_buf_length = rx_length;
  rx_buf = new char[rx_buf_length];
  sentence_buf_length = sentence_length;
  sentence_buf = new char[sentence_buf_length];
  clear();

  // device->attach(this, &nmea_parser::Rx_interrupt, Serial::RxIrq);
  device->attach(callback(this, &nmea_parser::Rx_interrupt), Serial::RxIrq);
}

nmea_parser::~nmea_parser()
{
    // device->attach(NULL, Serial::RxIrq); // don't know if that really helps
    delete [] rx_buf;
    rx_buf_length = 0;
    delete [] sentence_buf;
    sentence_buf_length = 0;
    printf ("nmea_parser destructed\n");
}

void nmea_parser::start(){
    rx_enable = true;
}

void nmea_parser::stop(){
    rx_enable = false;
}

void nmea_parser::clear(){
  rx_in = rx_out = 0;
  sentence_count = 0;
  rx_buf_overflow = false;
  rx_enable = false;
}

// Read a sentence from the rx buffer filled by rx interrupt routine
char * nmea_parser::read_sentence()
{
    int i = 0;

    if (sentence_count < 1) return (NULL); // return if nothing new
// Start Critical Section - don't interrupt while changing global buffer variables
//   NVIC_DisableIRQ(UART1_IRQn);
    sentence_count -= 1;
    while ((i==0) || (sentence_buf[i-1] != '\n')) {
        sentence_buf[i] = rx_buf[rx_out];
        i++;
        rx_out = (rx_out + 1) % rx_buf_length;
    }
// End Critical Section
//  NVIC_EnableIRQ(UART1_IRQn);
    sentence_buf[i-1] = '\0';
    return(sentence_buf);
}

// Interupt Routine to read in data from serial port
void nmea_parser::Rx_interrupt() {
char c;
        
// Loop just in case more than one character is in UART's receive FIFO buffer
// Stop if buffer full
//    while ((device->readable()) && (((rx_in + 1) % rx_buf_length) != rx_out)) {
    while (device->readable()) {
        c = device->getc();
        if (rx_enable) {
          rx_buf[rx_in] = c;
          if (c == '\n') sentence_count += 1;
          rx_in = (rx_in + 1) % rx_buf_length; }}

    return;
}

void nmea_parser::Rx_no_interrupt() {
}


int nmea_parser::analyze_sentence(char * p)
{
    strcpy(p,sentence_buf);
    return (analyze_sentence());
}

int nmea_parser::analyze_sentence()
{
    int nchar = 0, rv = 0;
        
    char * p = strstr(sentence_buf,"$POV,C,");
    
    if (*p == '\0') {return (0);}
    
    char * p_star = strchr(p+8,'*');
    if (*p_star != '\0') {*p_star = '\0';}
    else {return (0);}
    
    p += 7;
    nchar= p_star - p;
    if ((nchar < 1) || (nchar > 4)) {return (0);}
    
    for (rv=0;nchar > 0; nchar--) {
        rv = (rv << 8) | (0xff & *p++); }
        
    return (rv);
}

