#include "my_rtc.hpp"

long unsigned
my_RTC::read_backup_reg(long unsigned BackupRegister)
{
    RTC_HandleTypeDef RtcHandle;
    RtcHandle.Instance = RTC;
    return HAL_RTCEx_BKUPRead(&RtcHandle, BackupRegister);
}

void
my_RTC::write_backup_reg(long unsigned BackupRegister, long unsigned data)
{
    RTC_HandleTypeDef RtcHandle;
    RtcHandle.Instance = RTC;
    HAL_PWR_EnableBkUpAccess();
    HAL_RTCEx_BKUPWrite(&RtcHandle, BackupRegister, data);
    HAL_PWR_DisableBkUpAccess();
}

long unsigned
my_RTC::adjust_clock(Ext_Serial * ser)
{
    time_t seconds;
    long unsigned t0 = 1487152800; // 2017 Feb 15, 10:00:00 UTC
    int bytes_read;
    char my_string[101], *s, c;
    bool rd_more;
    struct tm t;
    
    seconds = time(NULL);
    ser->printf("Time as seconds since January 1, 1970 = %d\n", seconds);
    ser->printf("I think it is UTC %s", ctime(&seconds));

    // get the current time from the terminal

    ser->printf("\nEnter current UTC date and time or enter empty:\n");
    ser->printf("YYYY MM DD HH MM[enter]\n");

    for (rd_more = true, s = my_string, bytes_read=0; rd_more;) {
	c = ser->getc();
	ser->putc(c);
	switch (c) {
	    case '\r':
	    case '\n':
		*s = '\0';
		rd_more = false;
		break;
	    case '\b':
		if (bytes_read > 0) {
		    bytes_read -= 1;
		    s -= 1;
		}
		break;
	    default:
		*s++ = c;
		bytes_read += 1;
	}
    }

    ser->printf("You entered %d bytes: --->%s<---\n",bytes_read,my_string);
    if (bytes_read > 10) {
	sscanf(my_string,"%d %d %d %d %d", &t.tm_year, &t.tm_mon, &t.tm_mday
	       , &t.tm_hour, &t.tm_min);

	t.tm_sec = 0;
	// adjust for tm structure required values
	t.tm_year = t.tm_year - 1900;
	t.tm_mon = t.tm_mon - 1;

	// set the time
	t0 = mktime(&t);
	ser->printf("set_time(%d)\n",t0);
	set_time(t0);

	seconds = time(NULL);
	ser->printf("%d seconds since January 1, 1970. This is ", seconds);
	ser->printf("UTC %s", ctime(&seconds));
    } else {
	ser->printf("RTC not set\n");
	t0 = 0;
    }
    return (t0);
}

