#include "mbed.h"
#include <DigitalOut.h>
#include <SPI.h>
// #define BMP280_32BIT_CALCULATION
// #define BMP280_ENABLE_INT64
#define BMP280_ENABLE_FLOAT

#include "my_bmp280.h"


void BMP280::select() {
    //Set CS low to start transmission (interrupts conversion)

//    SPI.beginTransaction(SPISettings(my_clock, MSBFIRST, SPI_MODE3));
//    digitalWrite(my_cs, LOW);
    // SPI_bus->lock();
    SPI_cs->write(0);

}
void BMP280::deselect() {
    //Set CS high to stop transmission (restarts conversion)

//    digitalWrite(my_cs, HIGH);
//    SPI.endTransaction();
    SPI_cs->write(1);
    // SPI_bus->unlock();
}

uint8_t BMP280::read_spi_8b(u8 raddr)
{
    uint8_t rv;
    select();
    SPI_bus->write(raddr | 0x80);
    rv = SPI_bus->write(0);
    deselect();
    return (rv);
}

void BMP280::read_spi_8b(u8 reg_addr, u8 *reg_data, int cnt)
{
    select();
    SPI_bus->write(reg_addr | SPI_READ);
    for (; cnt > 0; cnt--) {
       *reg_data++ = SPI_bus->write(0); }
    deselect();
}

void BMP280::write_spi_8b(u8 raddr,uint8_t rdata)
{
    select();
    SPI_bus->write(raddr & SPI_WRITE);
    SPI_bus->write(rdata);
    deselect();
}

bool BMP280::read_chipID(u8 expected)
{
    u8 rv;
    int i;
    
    for (i=0; i < 5; i++) {
    	rv = read_spi_8b(BMP280_CHIP_ID_REG);
    	if (rv == expected) { present = true; return (true); }
    	}
    present = false;
    return (false);
}

bool BMP280::is_busy()
{
    if(!present) { return false; }
    return (read_spi_8b(BMP280_STAT_REG) & 8);
}

void BMP280::start_measure_cycle()
{
	if(!present) { return; }
	write_spi_8b(BMP280_CTRL_MEAS_REG,ctrl_meas);
}

s32 BMP280::get_uncomp_temp()
{
	if(!present) { return(0); }
	s32 rv;
	
	rv = (s32)((((u32)(raw_data[3])) << 12)
            | (((u32)(raw_data[4])) << 4)
            | ((u32)raw_data[5] >> 4));
    return (rv);
}

s32 BMP280::get_uncomp_press()
{
	if(!present) { return(0); }
	s32 rv;
	
	rv = (s32)((((u32)(raw_data[0])) << 12)
            | (((u32)(raw_data[1])) << 4)
            | ((u32)raw_data[2] >> 4));
    return (rv);
}

void BMP280::set_filter()
{
	write_spi_8b(BMP280_CONFIG_REG,filter);
}

void BMP280::unload_calibration_parameter()
{
	if(!present) { return; }
	read_spi_8b(BMP280_TEMPERATURE_CALIB_DIG_T1_LSB_REG,
                   (u8 *)&calib_param, sizeof(calib_param)-4);
}

void BMP280::print_calibration_parameter(Serial *channel, const char * name)
{
    if(!present) { return; }
    u8 * p;
    u8 i;
    channel->printf("%s: Calibration Data, %d bytes:",name,sizeof(calib_param)-4);
    p = (u8 *)&calib_param;
    for (i = 0; i < (sizeof(calib_param)-4); i++) {
        channel->printf("%x.",*p++);
    }
    channel->printf(";\n");
}

void BMP280::print_settings(Serial *channel, const char * name)
{
    if(!present) {
    	channel->printf("%s: not present\n",name);
    	return; }
	uint8_t v;
    
    v = read_spi_8b(BMP280_CONFIG_REG);
    channel->printf("%s: Config Reg: T_standby=0x%0X, IIR filter=0x%0X\n",name,(0x7 & (v >> 5)),(0x7 & (v >> 2)));
    v = read_spi_8b(BMP280_CTRL_MEAS_REG);
    channel->printf("%s: Ctrl Measure Reg: osrs_p=0x%0X, osrs_t=0x%0X\n",name,(0x7 & (v >> 2)),(0x7 & (v >> 5)));
}

void BMP280::unload_raw_data()
{
	if(!present) { return; }
	read_spi_8b(BMP280_PRESSURE_MSB_REG,raw_data,sizeof(raw_data));
}

#ifdef BMP280_ENABLE_FLOAT
/*!
 * @brief This API used to read
 * actual temperature from uncompensated temperature
 * @note Returns the value in Degree centigrade
 * @note Output value of "51.23" equals 51.23 DegC.
 *
 */
fpct BMP280::compensate_temperature(s32 v_uncomp_temperature_s32)
{
    if(!present) { return(0); }
    fpct v_x1_u32r = BMP280_INIT_VALUE;
    fpct v_x2_u32r = BMP280_INIT_VALUE;
    
    temperature = BMP280_INIT_VALUE;
    /* calculate x1*/
    v_x1_u32r = (((fpct)v_uncomp_temperature_s32) / (fpct)16384.0 -
            ((fpct)calib_param.dig_T1) / (fpct)1024.0) *
    ((fpct)calib_param.dig_T2);
    /* calculate x2*/
    v_x2_u32r = ((((fpct)v_uncomp_temperature_s32) / (fpct)131072.0 -
            ((fpct)calib_param.dig_T1) / (fpct)8192.0) *
            (((fpct)v_uncomp_temperature_s32) / (fpct)131072.0 -
            ((fpct)calib_param.dig_T1) / (fpct)8192.0)) *
    ((fpct)calib_param.dig_T3);
    /* calculate t_fine*/
    calib_param.t_fine = (s32)(v_x1_u32r + v_x2_u32r);
    /* calculate true pressure*/
    temperature = (v_x1_u32r + v_x2_u32r) / (fpct)5120.0;

    return temperature;
}

/*!
 *  @brief Reads actual pressure from uncompensated pressure
 *  and returns pressure in Pa as double.
 *  @note Output value of "96386.2"
 *  equals 96386.2 Pa = 963.862 hPa.
 *
 */
fpct BMP280::compensate_pressure(s32 v_uncomp_pressure_s32)
{
    if(!present) { return(0); }
    fpct v_x1_u32r = BMP280_INIT_VALUE;
    fpct v_x2_u32r = BMP280_INIT_VALUE;
    
    pressure = BMP280_INIT_VALUE;
    v_x1_u32r = ((fpct)calib_param.t_fine/(fpct)2.0) - (fpct)64000.0;
    v_x2_u32r = v_x1_u32r * v_x1_u32r *
    ((fpct)calib_param.dig_P6) / (fpct)32768.0;
    v_x2_u32r = v_x2_u32r + v_x1_u32r *
    ((fpct)calib_param.dig_P5) * (fpct)2.0;
    v_x2_u32r = (v_x2_u32r / (fpct)4.0) +
    (((fpct)calib_param.dig_P4) * (fpct)65536.0);
    v_x1_u32r = (((fpct)calib_param.dig_P3) *
        v_x1_u32r * v_x1_u32r / (fpct)524288.0 +
        ((fpct)calib_param.dig_P2) * v_x1_u32r) / (fpct)524288.0;
    v_x1_u32r = ((fpct)1.0 + v_x1_u32r / (fpct)32768.0) *
    ((fpct)(0xFFFF & calib_param.dig_P1));  // fix for gcc
    pressure = (fpct)1048576.0 - (fpct)v_uncomp_pressure_s32;
    /* Avoid exception caused by division by zero */
    if ((v_x1_u32r > 0) || (v_x1_u32r < 0))
        pressure = (pressure - (v_x2_u32r / (fpct)4096.0)) *
                    (fpct)6250.0 / v_x1_u32r;
    else
    return BMP280_INVALID_DATA;
    v_x1_u32r = ((fpct)calib_param.dig_P9) *
    pressure * pressure / (fpct)2147483648.0;
    v_x2_u32r = pressure * ((fpct)calib_param.dig_P8) / (fpct)32768.0;
    pressure = pressure + (v_x1_u32r + v_x2_u32r +
            ((fpct)calib_param.dig_P7)) / (fpct)16.0;

    return pressure;
}
#else
/*!
 *  @brief Reads actual temperature
 *  from uncompensated temperature
 *  @note Returns the value in 0.01 degree Centigrade
 *  @note Output value of "5123" equals 51.23 DegC.
 */
s32 BMP280::compensate_temperature(s32 v_uncomp_temperature_s32)
{
    if(!present) { return(0); }
    s32 v_x1_u32r = BMP280_INIT_VALUE;
    s32 v_x2_u32r = BMP280_INIT_VALUE;
    
    temperature = BMP280_INIT_VALUE;
    /* calculate true temperature*/
    /*calculate x1*/
    v_x1_u32r = ((((v_uncomp_temperature_s32
            >> BMP280_SHIFT_BIT_POSITION_BY_03_BITS)
            - ((s32)calib_param.dig_T1
            << BMP280_SHIFT_BIT_POSITION_BY_01_BIT)))
            * ((s32)calib_param.dig_T2))
            >> BMP280_SHIFT_BIT_POSITION_BY_11_BITS;
    /*calculate x2*/
    v_x2_u32r = (((((v_uncomp_temperature_s32
            >> BMP280_SHIFT_BIT_POSITION_BY_04_BITS)
            - ((s32)calib_param.dig_T1))
            * ((v_uncomp_temperature_s32
            >> BMP280_SHIFT_BIT_POSITION_BY_04_BITS)
            - ((s32)calib_param.dig_T1)))
            >> BMP280_SHIFT_BIT_POSITION_BY_12_BITS)
            * ((s32)calib_param.dig_T3))
            >> BMP280_SHIFT_BIT_POSITION_BY_14_BITS;
    /*calculate t_fine*/
    calib_param.t_fine = v_x1_u32r + v_x2_u32r;
    /*calculate temperature*/
    temperature = (calib_param.t_fine * 5 + 128)
            >> BMP280_SHIFT_BIT_POSITION_BY_08_BITS;

    return temperature;
}
/*!
 * @brief This API used to read actual pressure from uncompensated pressure
 * @note returns the value in Pa as unsigned 32 bit
 * integer in Q24.8 format (24 integer bits and
 * 8 fractional bits). Output value of "24674867"
 * represents 24674867 / 256 = 96386.2 Pa = 963.862 hPa
 */
u32 BMP280::compensate_pressure(s32 v_uncomp_pressure_s32)
{
    if(!present) { return(0); }
    s64 v_x1_s64r = BMP280_INIT_VALUE;
    s64 v_x2_s64r = BMP280_INIT_VALUE;
    s64 pressure = BMP280_INIT_VALUE;
    /* calculate x1*/
    v_x1_s64r = ((s64)calib_param.t_fine) - 128000;
    v_x2_s64r = v_x1_s64r * v_x1_s64r *
    (s64)calib_param.dig_P6;
    /* calculate x2*/
    v_x2_s64r = v_x2_s64r + ((v_x1_s64r * (s64)calib_param.dig_P5)
            << BMP280_SHIFT_BIT_POSITION_BY_17_BITS);
    v_x2_s64r = v_x2_s64r +
    (((s64)calib_param.dig_P4)
            << BMP280_SHIFT_BIT_POSITION_BY_35_BITS);
    v_x1_s64r = ((v_x1_s64r * v_x1_s64r *
            (s64)calib_param.dig_P3)
            >> BMP280_SHIFT_BIT_POSITION_BY_08_BITS) +
    ((v_x1_s64r * (s64)calib_param.dig_P2)
            << BMP280_SHIFT_BIT_POSITION_BY_12_BITS);
    v_x1_s64r = (((((s64)1) << BMP280_SHIFT_BIT_POSITION_BY_47_BITS)
            + v_x1_s64r)) * ((s64)(0xFFFF & calib_param.dig_P1)) >>  // fix for gcc
            BMP280_SHIFT_BIT_POSITION_BY_33_BITS;
    pressure = 1048576 - v_uncomp_pressure_s32;
    if (v_x1_s64r != BMP280_INIT_VALUE)
        pressure = (((pressure
                << BMP280_SHIFT_BIT_POSITION_BY_31_BITS)
                - v_x2_s64r) * 3125) / v_x1_s64r;
    else
        return BMP280_INVALID_DATA;
    v_x1_s64r = (((s64)calib_param.dig_P9) *
            (pressure >> BMP280_SHIFT_BIT_POSITION_BY_13_BITS) *
            (pressure >> BMP280_SHIFT_BIT_POSITION_BY_13_BITS))
    >> BMP280_SHIFT_BIT_POSITION_BY_25_BITS;
    v_x2_s64r = (((s64)calib_param.dig_P8) *
            pressure) >> BMP280_SHIFT_BIT_POSITION_BY_19_BITS;
    /* calculate pressure*/
    pressure = ((pressure + v_x1_s64r + v_x2_s64r)
            >> BMP280_SHIFT_BIT_POSITION_BY_08_BITS) +
    (((s64)calib_param.dig_P7)
            << BMP280_SHIFT_BIT_POSITION_BY_04_BITS);
    pressure = (u32)pressure;    
    return pressure;
}
#endif

