#ifndef nmea_parser_INCLUDE_H
#define nmea_parser_INCLUDE_H

class nmea_parser {
public:
    // constructor
  
  Serial * device;
  char *rx_buf;
  int rx_buf_length;
  volatile int rx_in, rx_out;
  char *sentence_buf;
  int sentence_buf_length;
  volatile int  sentence_count;
  bool rx_buf_overflow;
  bool rx_enable;

  nmea_parser(int rx_length, int sentence_length, Serial * uart);
  ~nmea_parser();
  void set_channel (Serial * uart) {device = uart;}
  void Rx_interrupt();
  void Rx_no_interrupt();
  char * read_sentence();
  int  analyze_sentence(char * p);
  int  analyze_sentence();
  void start();
  void stop();
  void clear();
};

#endif // nmea_parser_INCLUDE_H

