#ifndef MYTYPES_INCLUDE_H
#define MYTYPES_INCLUDE_H

// #include <stdint.h>
typedef  int8_t s8;/**< used for signed 8bit */
typedef int16_t s16;/**< used for signed 16bit */
typedef int32_t s32;/**< used for signed 32bit */
typedef int64_t s64;/**< used for signed 64bit */

typedef uint8_t u8;/**< used for unsigned 8bit */
typedef signed short u16;/**< used for unsigned 16bit */
typedef signed long u32;/**< used for unsigned 32bit */
typedef signed long long u64;/**< used for unsigned 64bit */

typedef double fpct; /**< used for calculation, can be float or double */

#define NVM_OFFSET      0
#define NVM_NBYTES	20
union nvm_t {
  uint8_t v_byte[NVM_NBYTES];
  u16 v_int[NVM_NBYTES/sizeof(u16)];
  u32 v_long[NVM_NBYTES/sizeof(u32)];
  float v_float[NVM_NBYTES/sizeof(float)];
  };
    

#endif // MYTYPES_INCLUDE_H



