#include "mbed.h"
#include "filters.h"

/*** depriciated *********************************
fpct filters::vario_filter(fpct altitude)
{  
  fpct v;
  int i;
  
  for (i=(2*filter_length)-1; i>0 ; i--)
    { filter_array[i]=filter_array[i-1]; }
    filter_array[0] = altitude;
  for (v=0.0, i=0;i<filter_length;i++)
    { v = v + filter_array[i] - filter_array[i+filter_length]; }
  if (invalid_data_cnt > 0) {invalid_data_cnt -= 1; return ((fpct) 0.0); }
  return (v * (fpct)((fpct)sample_rate/((fpct)filter_length*(fpct)filter_length)));
}
**************************************************/

fpct filters::diff_fir(fpct altitude)
{  
  raw_sum += ((altitude + filter_array[io_index]) - (filter_array[mid_index] + filter_array[mid_index]));
  filter_array[io_index] = altitude;
  io_index = (io_index + 1) % (2*filter_length);
  mid_index = (io_index + filter_length) % (2*filter_length);

  if (invalid_data_cnt > 0) {invalid_data_cnt -= 1; return ((fpct) 0.0); }
  return (raw_sum * (fpct)((fpct)sample_rate/((fpct)filter_length*(fpct)filter_length)));
}

fpct filters::avg_fir(fpct p)
{  
  raw_sum += (p - filter_array[io_index]);
  filter_array[io_index] = p;
  io_index = (io_index + 1) % array_length;

  if (invalid_data_cnt > 0) {invalid_data_cnt -= 1; return ((fpct) 0.0); }
  return (raw_sum / (fpct)array_length);
}

/*** depriciated *********************************
fpct filters::pressure_filter(fpct p)
{  
  fpct v;
  int i;
  
  for (i=filter_length-1; i>0 ; i--)
    { filter_array[i]=filter_array[i-1]; }
    filter_array[0] = p;
  for (v=0.0, i=0;i<filter_length;i++)
    { v = v + filter_array[i]; }
  return (v / (fpct)filter_length);
}
**************************************************/

#ifdef TESTBENCH
void filters::pr_array()
{  
  int i;

  for (i=0; i < (2*filter_length); i++)
    {
    printf ("%3.2f ",filter_array[i]);
    }
  printf ("\nio: %d, mid: %d\n",io_index,mid_index);
}
#endif

