
#ifndef VARIO_DISPLAY_HPP
#define VARIO_DISPLAY_HPP

#include "mbed.h"

/**
 * This class implements the vario display, usually an analog needle instrument
 */
class VarioDisplay {

public:
  VarioDisplay (PinName needle_pin,
  float _min_scale = -5.0,
  float _max_scale =  5.0,
  float _offset    =  0.5,
  float _gain      = 0.095,
  unsigned int _pw_us = 500);

  /**
   * Set the needle to the value in m/sec
   */
  void SetNeedle(float vario);
  
  /**
   * Set 0 offset
   */
  void SetZero(float zero_val);
  float GetZero(void);
  
  /**
   * Set gain
   */
  void SetGain(float gain_val);
  float GetGain(void);
  
private:

  PwmOut needle_;
  float min_scale;
  float max_scale;
  float offset;
  float gain;
  unsigned int pw_us;

};

#endif


