#define BUILD_INFO "Vario_101_407mini"

#define	SWAP_PC_GPS
#define DAC_SOUND
#define	PCB_LAYOUT_1
#define LED1    PB_9
#define     LED_OFF     1
#define     LED_ON      0

// AT24C08 connected here:
#define AT24C08_NVM
#define AT24C08_SDA	PB_7
#define AT24C08_SCL	PB_6
at24c08 eeprom(AT24C08_SDA, AT24C08_SCL, 0xA0, 400000);


SPI spi1(PA_7, PA_6, PA_5); // SPI_MOSI, SPI_MISO, SPI_SCK
#ifdef	PCB_LAYOUT_1
DigitalOut TE_cs(PC_1,1);
#else
DigitalOut TE_cs(PA_4,1);
#endif
DigitalOut PITOT_cs(PC_3,1);  
DigitalOut STAT_cs(PC_2,1);  

#ifdef IMU_CONNECTED
#define SPI2_BUS_CLOCK 10000000
SPI spi2(PB_15,PB_14,PB_13);
#ifdef	PCB_LAYOUT_1
DigitalOut IMU_cs(PD_1,1);
DigitalIn IMU_intr(PD_2,PullNone);
#else
DigitalOut IMU_cs(PB_1,1);
DigitalIn IMU_intr(PB_2,PullNone);
#endif
#endif

Ext_Serial _nmea_port(PA_9, PA_10); // TX RX
#ifdef	SWAP_PC_GPS
Ext_Serial _pc(PC_6, PC_7); // TX RX
Serial gps_port(PA_2, PA_3); // TX RX
#else
Ext_Serial _pc(PA_2, PA_3);
Serial gps_port(PC_6, PC_7); // TX RX
#endif

InterruptIn one_pps(PB_2); // 1-pps signale from GPS
one_pps.mode(PullDown);

InterruptIn my_button(PE_4);
my_button.mode(PullUp);
#define USER_BUTTON_POLARITY_POSITIVE


#ifdef DAC_SOUND
AnalogOut VarioSound(PA_4); // DAC 1
VarioDisplay vneedle(PA_15); // TIM2/1
#else
PwmOut VarioSound(PB_0); // TIM3/3
DigitalOut VarioModulation(PA_0,1);
PwmOut VarioVolume(PA_15); // TIM2/1
VarioDisplay vneedle(PB_8); // TIM1/1
#endif

// Rotary Encoder
QEI Rotary_Enc (PD_9, PD_8, 24);
InterruptIn Rotary_Button(PD_10);
Rotary_Button.mode(PullUp);
// Speed to fly switch
DigitalIn Speed2fly(PD_11,PullUp);
// DigitalIn Aux_Switch(PD_11,PullUp);


