#define INIT_MEASURE_FREQ 14 // measure frequenzy in Hz (safely up to 25 Hz), should be an even number from 8 to 24
#define INIT_READINGS_PER_LOOP 2

// #define REPORT_LOOP_TIMES
// #define REPORT_SENSOR_TEMP
#define ZERO_OFFS_AVG_CNT 20
// #define DEBUG_LEVEL_1
// #define BMP280_32BIT_CALCULATION
// #define BMP280_ENABLE_INT64
#define BMP280_ENABLE_FLOAT

#include "mbed.h"
#include "DigitalOut.h"
#include "ext_ser.hpp"
#include "my_bmp280.h"
#include "avs.h"
#include "filters.h"
#include "VarioSynthesiser.hpp"
#include "VarioDisplay.hpp"
#include "my_rtc.hpp"
#include "nmea_parser.hpp"
#include "QEI.h"
#include "at24c08.h"

#define SPI1_BUS_CLOCK 10000000
// #define NMEA_PORT_SPEED 38400
#define NMEA_PORT_SPEED 115200
#define PC_PORT_SPEED   115200
#define GPS_PORT_SPEED  9600

#include "utils.hpp"

// this flag prevents unintended changes in the setup
bool enable_deep_settings = false;

Timer t;

bool button_state = false;
void button_pressed()
{
    if (enable_deep_settings) button_state = true;
    return;
}


/* handle interrupts from rotary button
*/
unsigned int rotary_button_press_time = 0;
bool rotary_button_flag = false;
bool toggle_audio_mode = false;

void rotary_button_pressed()
{
  rotary_button_flag = true;
  rotary_button_press_time = t.read_ms();
}
void rotary_button_released()
{
  if (rotary_button_flag) {
    int tdiff = t.read_ms() - rotary_button_press_time;
    if (tdiff > 10) {
      toggle_audio_mode = true;
    }
  }
  rotary_button_flag = false;
}

/* end of rotary button handler */

bool time_puls_flag;
unsigned int last_1pp = 0, now_1pp = 0;
int d_1pp;
void time_puls_intr()
{
    now_1pp = t.read_ms();
    time_puls_flag = true;
    return;
}

void pr_clk_setup(Ext_Serial * ser) {
    // RCC_ClkInitTypeDef RCC_ClkInitStruct;
    RCC_OscInitTypeDef ois;
 
    HAL_RCC_GetOscConfig(&ois);

    ser->printf("HSEState: 0x%x\nLSIState: 0x%x\nLSEState: 0x%x\n",ois.HSEState,ois.LSIState,ois.LSEState);
    /****
    RCC_OscInitStruct.OscillatorType = RCC_OSCILLATORTYPE_LSI|RCC_OSCILLATORTYPE_HSE;
    RCC_OscInitStruct.HSEState = RCC_HSE_ON;
    RCC_OscInitStruct.LSIState = RCC_LSI_ON;
    RCC_OscInitStruct.PLL.PLLState = RCC_PLL_ON;
    RCC_OscInitStruct.PLL.PLLSource = RCC_PLLSOURCE_HSE;
    RCC_OscInitStruct.PLL.PLLM = 18;
    RCC_OscInitStruct.PLL.PLLN = 302;
    RCC_OscInitStruct.PLL.PLLP = RCC_PLLP_DIV4;
    RCC_OscInitStruct.PLL.PLLQ = 4;
    HAL_RCC_OscConfig(&RCC_OscInitStruct);
 
    RCC_ClkInitStruct.ClockType = RCC_CLOCKTYPE_SYSCLK|RCC_CLOCKTYPE_PCLK1;
    RCC_ClkInitStruct.SYSCLKSource = RCC_SYSCLKSOURCE_PLLCLK;
    RCC_ClkInitStruct.APB1CLKDivider = RCC_HCLK_DIV2;
    HAL_RCC_ClockConfig(&RCC_ClkInitStruct, FLASH_LATENCY_2);
    
    SystemCoreClockUpdate();
    SystemCoreClock = 83890000;
    **/
}

void 
start_all3_measure_cycles(SPI * spi,DigitalOut * TE_cs,DigitalOut * STAT_cs,DigitalOut * PITOT_cs,u8 raddr,uint8_t rdata)
{
  // select
  TE_cs->write(0);
  STAT_cs->write(0);
  PITOT_cs->write(0);
  // write_spi_8b(BMP280_CTRL_MEAS_REG,ctrl_meas);
  spi->write(raddr & SPI_WRITE);
  spi->write(rdata);
  // deselect
  TE_cs->write(1);
  STAT_cs->write(1);
  PITOT_cs->write(1);
}

int main()
{
#include "PINS_DEF.hpp"
    bool TE_TEST_CYCLE = ! Rotary_Button; // enter the Test Cycle if the Rotary_Button is LOW at power up
    DigitalOut  myled(LED1);

    myled = LED_ON;
    bool s2f = true;
    bool s2f_last = false;
    int cnt_now = 0;
    int prev_count = 0;

    bool RTC_present = true;
#ifdef AT24C08_NVM
    bool eeprom_present = true;
#endif

    float vario_needle_gain, vario_needle_offs;
    bool change_vario_gauge_gain=false, change_vario_gauge_offset=false;
    bool init_vario_gauge_param=false;
    int incr_vario_gauge_gain=0, incr_vario_gauge_offset=0;
    int gate_vario_gauge_change=0;

    
    Ext_Serial * pc, * nmea_port, * tmp_swp;

    _nmea_port.baud(NMEA_PORT_SPEED);
    _pc.baud(PC_PORT_SPEED);
    gps_port.baud(GPS_PORT_SPEED);

    const char greetings[] = "\n\n%s\nBuild date %d\n========================\nGood Day!\nHere is the ";
    _pc.printf(greetings,BUILD_INFO,MBED_BUILD_TIMESTAMP);
    _pc.printf("PC-port\n");
    _nmea_port.printf(greetings,BUILD_INFO,MBED_BUILD_TIMESTAMP);
    _nmea_port.printf("NMEA-port\n");
			
    _pc.printf("SystemCoreClock = %d Hz\n", SystemCoreClock);
    pr_clk_setup(&_pc);

    pc = &_pc;
    nmea_port = &_nmea_port;
// Timer t;

    time_puls_flag = false;

    uint8_t p_configuration = 0;




    bool button_flag = false;
    char message_buf[100],c_rxtx,*sentence_p;

    unsigned loop_cnt_mod=0, loop_cnt=0, w_cnt=0;
    uint8_t loop_freq=INIT_MEASURE_FREQ;
    unsigned time_slices_per_loop, readings_per_loop=INIT_READINGS_PER_LOOP;
    uint8_t f_length_half;
    int dms=0, l_dms=0, ll_dms=0, loop_time_ms = 1000 / loop_freq; // ms per loop
    /* default length of Vario FIR in ms */
    int fir_length_ms=3000;
    uint32_t t0, target_time_ms, last_last_target_time_ms=0, last_target_time_ms=0, t1=0, t2=0;
    int cmd;

    // Set button Interrupt
    my_button.fall(&button_pressed);
    one_pps.rise(&time_puls_intr);
    Rotary_Button.fall(&rotary_button_pressed);
    Rotary_Button.rise(&rotary_button_released);
    pc->putc('a');
    BMP280 TEc(SPI1_BUS_CLOCK,&TE_cs,&spi1,0x55,0x10);
    BMP280 PITOTc(SPI1_BUS_CLOCK,&PITOT_cs,&spi1);
    BMP280 STATc(SPI1_BUS_CLOCK,&STAT_cs,&spi1);
    pc->putc('b');

    my_RTC rtc;

    pc->putc('c');

    int i;
    nvm_t nvm;

    pc->putc('d');
//    nmea_parser nmea_cmd(100,100,nmea_port); // MOVE

    // setup GPS Device
    /*******************************************
    wait_ms(500);
    gps_port.printf("$PMTK314,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0*28\r\n"); // GPRMC and GPGGA only
    wait_ms(200);
    gps_port.printf("$PMTK300,500,0,0,0,0*28\r\n"); // one fix every 500 ms
    ********************************************/

    // attach to interrup driven input
    nmea_parser gps_in(500,100,&gps_port);
    pc->putc('e');
#ifdef BMP280_ENABLE_FLOAT
    fpct TE_pressure=0, STAT_pressure=0, PITOT_pressure=0;
    fpct TE_rp, STAT_rp, PITOT_rp;
    fpct STAT_avg=0, PITOT_avg=0;
    TEc.zero_offs = PITOTc.zero_offs = STATc.zero_offs = 0.0f;
    fpct TE_temperature=0, STAT_temperature=0, PITOT_temperature=0;
#else
    u32 TE_pressure=0, STAT_pressure=0, PITOT_pressure=0;
    u32 TE_rp, STAT_rp, PITOT_rp;
    u32 STAT_avg=0, PITOT_avg=0;
    TEc.zero_offs = PITOTc.zero_offs = STATc.zero_offs = 0;
    s32 TE_temperature=0, STAT_temperature=0, PITOT_temperature=0;
#endif
    pc->putc('f');
    fpct press_scale=1.0f, Vario=0, p_avg;
    float QNH_val = 1013.25;
    TE_rp=STAT_rp=PITOT_rp=QNH_val;

    bool keep_going=true;
    int avg_cnt = 0;
#ifdef DAC_SOUND
    VarioSynthesiser vsynth(loop_freq/readings_per_loop,&VarioSound,pc); // MOVE
#else
    VarioSynthesiser vsynth(loop_freq/readings_per_loop,&VarioSound,&VarioModulation,&VarioVolume,pc); // MOVE
#endif
    pc->putc('\n');
#ifdef DEBUG_LEVEL
    u8 *u8_pntr;
#endif

    time_t utc_seconds = time(NULL);
    // pc->printf("%ld sec since Jan 1 1970\n", utc_seconds);
    if (RTC_present && ((utc_seconds+1) != 0) && (utc_seconds > 1483604461)) {
        pc->printf("UTC: %s", ctime(&utc_seconds)); // after Jan 2017 it's a real date!
        nmea_port->printf("UTC: %s", ctime(&utc_seconds)); // after Jan 2017 it's a real date!
    } else {
        pc->printf("no RTC\n");
        RTC_present = false;
    }

    pc->printf("Hello BMP280\n");

    TEc.read_chipID(0x58); // this is the first access to this SPI bus. Get it going!

    if (TEc.read_chipID(0x58)) {
        pc->printf("  Found TE sensor\n");
    } else {
        pc->printf("Failed connection BMP280 TE\n");
    }

    if (PITOTc.read_chipID(0x58)) {
        pc->printf("  Found PITOT sensor\n");
    } else {
        pc->printf("Failed connection BMP280 PITOT\n");
    }

    if (STATc.read_chipID(0x58)) {
        pc->printf("  Found STAT sensor\n");
    } else {
        pc->printf("Failed connection BMP280 STAT\n");
    }

    p_configuration = 0;
    if (PITOTc.present && STATc.present) p_configuration = 2;
    if (TEc.present && PITOTc.present && STATc.present) p_configuration = 3;

#ifdef BMP280_ENABLE_FLOAT
    pc->printf("  FLOAT arithmetic. Size of type fpct: %d bytes\n",sizeof(fpct));
#endif
#ifdef BMP280_ENABLE_INT64
    pc->printf("  INT64 arithmetic. Size of s64: %d bytes\n",sizeof(s64));
#endif
#ifdef BMP280_32BIT_CALCULATION
    pc->printf("  INT32 arithmetic. Size of s32: %d bytes\n",sizeof(s32));
#endif

#ifdef DEBUG_LEVEL
    pc->printf("ctrl_meas_reg: 0x%x\n",TEc.ctrl_meas);
    pc->printf("config_reg (filter): 0x%x\n",TEc.filter);
#endif

    if (p_configuration == 0) {
	const char* useless_conf = "ERROR Exit: Pressure Sensor configuration is useless!\n";
        pc->printf(useless_conf);
        nmea_port->printf(useless_conf);
        exit(1);
    }

    TEc.unload_calibration_parameter();
    STATc.unload_calibration_parameter();
    PITOTc.unload_calibration_parameter();

#ifdef DEBUG_LEVEL_1
    TEc.print_calibration_parameter(pc,"TE");
    STATc.print_calibration_parameter(pc,"STAT");
    PITOTc.print_calibration_parameter(pc,"PITOT");
#endif

    if (RTC_present) {
        if (rtc.read_backup_reg(0) != 0x12345678) { // the magic number
            pc->printf("Init NVM in RTC\n");
            nvm.v_float[0]=nvm.v_float[1]=nvm.v_float[2]=0.0f;
	    vario_needle_gain = nvm.v_float[3] = 0.094;
	    vario_needle_offs  = nvm.v_float[4] = 0.510;
            for (i=0; i<(int)(NVM_NBYTES/sizeof(u32)); i++) {
                rtc.write_backup_reg(i+1,nvm.v_long[i]);
            }
            rtc.write_backup_reg(0,0x12345678);
        } else {
            pc->printf("NVM: found magic number\n");
        }
        for (i=0; i<(int)(NVM_NBYTES/sizeof(u32)); i++) {
            nvm.v_long[i] = rtc.read_backup_reg(i+1);
        }
        STATc.zero_offs = nvm.v_float[0];
        PITOTc.zero_offs = nvm.v_float[1];
	vario_needle_gain = nvm.v_float[3];
	vario_needle_offs  = nvm.v_float[4];
#ifdef AT24C08_NVM
    } else if (eeprom_present) {
      u32 magic_num;
      eeprom.fetch(NVM_OFFSET,1,&magic_num);
      if (magic_num != 0x12345678) { // the magic number
	pc->printf("Init NVM in EEPROM\n");
	magic_num = 0x12345678;
	eeprom.store(NVM_OFFSET,1,&magic_num);
	STATc.zero_offs = PITOTc.zero_offs = 
	  nvm.v_float[0] = nvm.v_float[1] = 0.0f;
	vario_needle_gain = nvm.v_float[3] = 0.094;
	vario_needle_offs  = nvm.v_float[4] = 0.510;
	eeprom.store(NVM_OFFSET+4,5,&nvm.v_long[0]);
      } else {
	pc->printf("NVM: found magic number\n");
	eeprom.fetch(NVM_OFFSET+4,5,&nvm.v_long[0]);
	STATc.zero_offs = nvm.v_float[0];
	PITOTc.zero_offs = nvm.v_float[1];
	vario_needle_gain = nvm.v_float[3];
	vario_needle_offs  = nvm.v_float[4];
	}
#endif
    } else {
	STATc.zero_offs =
	    PITOTc.zero_offs = 0.0f;
	vario_needle_gain = 0.095;
	vario_needle_offs  = 0.5;
    }

    TEc.set_filter();
    STATc.set_filter();
    PITOTc.set_filter();

    pc->ungets("?");
    const char report_param[] = "Loop time %d ms == %d Hz\nTE FIR filter length = %d ms\n";
    const char announce_te_test[] = "TE demo active\n";

    avs_c AVS;

    while (1) {
        loop_time_ms = 1000 / loop_freq; // ms per loop
        f_length_half=fir_length_ms/(2*loop_time_ms);
        filters filter(f_length_half*2,f_length_half,loop_freq);
        time_slices_per_loop = loop_freq/readings_per_loop;

        pc->printf(report_param, loop_time_ms,loop_freq,f_length_half*2*loop_time_ms);
        nmea_port->printf(report_param, loop_time_ms,loop_freq,f_length_half*2*loop_time_ms);
	if (TE_TEST_CYCLE) { // fake TE pressure to test the Vario
	  pc->printf(announce_te_test);
	  nmea_port->printf(announce_te_test);
	  }


        // make sure the appropriate (interrupt) handlers are in place and connected to the propper UARTs (after a swap).
        nmea_parser nmea_cmd(100,100,nmea_port);
        pc->catch_rx_interrupt();

        // trigger first measure cycle
        // TEc.start_measure_cycle();
        // STATc.start_measure_cycle();
        // PITOTc.start_measure_cycle();
        // instead of sending 3 start measure commands we send a broadcast to all 3 at once
        // This is not critical nor pretty, but it does start all 3 measure cycles at the exact same time
	// This can be wrong if *.ctrl_meas are not intended to be the same
	if ((TEc.ctrl_meas==STATc.ctrl_meas) && (TEc.ctrl_meas==PITOTc.ctrl_meas)) {
	  start_all3_measure_cycles(&spi1,&TE_cs,&STAT_cs,&PITOT_cs,BMP280_CTRL_MEAS_REG,TEc.ctrl_meas);
          pc->printf("quick start measure\n");

	} else {
	  TEc.start_measure_cycle();
	  STATc.start_measure_cycle();
	  PITOTc.start_measure_cycle();
	}


        // the loop clock starts ticking now
        t.reset();
        t.start();
        t0 = t.read_ms();
        target_time_ms = t0 + loop_time_ms;
        loop_cnt_mod = loop_cnt = 0;

        // setup the accustic vario
        vsynth.SetDeadBand(true);
        vsynth.SetDualtoneMode(false);
        vsynth.SetDeadBandRange(-0.35f,+0.15f);


        // report settings of the BMP280
        TEc.print_settings(pc,"TE");
        STATc.print_settings(pc,"STAT");
        PITOTc.print_settings(pc,"PITOT");
        pc->printf("Zero-Offsets [Pa]: STAT=%.2f PITOT=%.2f\n",STATc.zero_offs,PITOTc.zero_offs);

        // setup the analog vario gauge
	vneedle.SetZero(vario_needle_offs);
	vneedle.SetGain(vario_needle_gain);
        pc->printf("Vario Gauge: gain=%.4f offset=%.4f\n",vneedle.GetGain(),vneedle.GetZero());

        vsynth.SetVario(+0.0f);

        while (STATc.is_busy()) {
            wait_ms(5);
        }
        gps_in.start();
        nmea_cmd.start();

        keep_going = true;
        do {
            if (time_puls_flag) { // this comes from a 1000 ms puls from the GPS device
                time_puls_flag = false;
                myled = !myled;
                d_1pp = now_1pp - last_1pp;
                // if ((d_1pp < 990) || (d_1pp > 1005)) { // Nr 2
                // if ((d_1pp < (980-5)) || (d_1pp > (980+5))) { // Nr 1
                if ((d_1pp < (996-5)) || (d_1pp > (996+5))) { // Nr 3
                // if ((d_1pp < (986-5)) || (d_1pp > (986+5))) { // Nr 4
                    pc->printf("dt: %d = t: %d - last t: %d, in loop %d, phase %d\n",
                               d_1pp,now_1pp,last_1pp,loop_cnt,loop_cnt_mod);
                }
                last_1pp = now_1pp;
            }

            loop_cnt++;
            loop_cnt_mod = loop_cnt % time_slices_per_loop;

            t2 = t1;
            t1 = t0;
            t0 = t.read_ms();
            ll_dms = l_dms;
            l_dms = dms;
            dms = target_time_ms - t0;
#ifdef REPORT_LOOP_TIMES
            pc->printf("N:%d, T:%d, D:%d\n",t0,target_time_ms,dms);
#endif
            if ((dms > (-1*loop_time_ms)) && (dms <= 2*loop_time_ms)) {
                if (dms > 1) {
                    wait_ms (dms+10);
                } else if (dms < 0) {
                    pc->printf("borrow %d ms in cycle %d\n",-1*dms,loop_cnt_mod);
                }
            } else {
                pc->printf("ERROR: Unexpected Loop time error: dms:%d, ldms:%d, lldms:%d, in loop %d cycle %d\nT:%d, lT:%d, llT:%d, t0:%d t1:%d t2:%d\n",
                           dms,l_dms,ll_dms,loop_cnt,loop_cnt_mod,target_time_ms,last_target_time_ms,last_last_target_time_ms,t0,t1,t2);
                if ((dms > 10) && (dms < 4*loop_time_ms)) wait_ms (dms+10);
            }
            last_last_target_time_ms = last_target_time_ms;
            last_target_time_ms = target_time_ms;
            if (t0 > 2000000) { // this is about 33 minutes after the last t.reset()
                pc->printf("reset timer before wrap around happens\n");
                t.reset();
                target_time_ms = t0 = t.read_ms();
            }

            target_time_ms += loop_time_ms; // target time for next loop


            // wait as long as device is still busy measuring before we read the data
            for (w_cnt=0; (w_cnt < 20) && (PITOTc.is_busy() || STATc.is_busy() || TEc.is_busy()); w_cnt++) {
                wait_ms(5);
                // pc->putc('w');
            }
            // pc->putc('\n');

            // read data from pressure sensors
            // measure cycle was started in the previous loop
            TEc.unload_raw_data();
            STATc.unload_raw_data();
            PITOTc.unload_raw_data();

            // trigger next measure cycle
	    // TEc.start_measure_cycle();
	    // STATc.start_measure_cycle();
	    // PITOTc.start_measure_cycle();
	    // instead of sending 3 start measure commands we send a broadcast to all 3 at once
	    // This is not critical nor pretty, but it does start all 3 measure cycles at the exact same time
	    // This can be wrong if *.ctrl_meas are not intended to be the same
	    if ((TEc.ctrl_meas==STATc.ctrl_meas) && (TEc.ctrl_meas==PITOTc.ctrl_meas)) {
	      start_all3_measure_cycles(&spi1,&TE_cs,&STAT_cs,&PITOT_cs,BMP280_CTRL_MEAS_REG,TEc.ctrl_meas);
	    } else {
	      TEc.start_measure_cycle();
	      STATc.start_measure_cycle();
	      PITOTc.start_measure_cycle();
	    }

            // process the data from the previous cycle
            if (TEc.present) {
                TE_temperature = TEc.compensate_temperature(TEc.get_uncomp_temp());
            } else {
                TE_temperature = 0.0f;
            }
            STAT_temperature = STATc.compensate_temperature(STATc.get_uncomp_temp());
            PITOT_temperature = PITOTc.compensate_temperature(PITOTc.get_uncomp_temp());


            if ((max3(TE_temperature,STAT_temperature,PITOT_temperature) > (fpct)85.0)
                    || (min3(TE_temperature,STAT_temperature,PITOT_temperature) < (fpct)-40.0)) {
                sprintf(message_buf,"ERROR: BMP280 temperature: TE=%f, STAT=%f, PITOT=%f, should be -40 C .. +85 C\n",TE_temperature,STAT_temperature,PITOT_temperature);
                AVS.nmea_alert(pc, err, message_buf);
            }

            STAT_rp = STATc.compensate_pressure(STATc.get_uncomp_press());
            STAT_pressure += ((STAT_rp - STATc.zero_offs)/(fpct)100.0);
            PITOT_rp = PITOTc.compensate_pressure(PITOTc.get_uncomp_press());
            PITOT_pressure += ((PITOT_rp - PITOTc.zero_offs)/(fpct)100.0);

    if (TE_TEST_CYCLE) { // fake TE pressure to test the Vario
            if (loop_cnt < 10*loop_freq) {
                if (p_configuration == 3) {
                    TE_rp = TEc.compensate_pressure(TEc.get_uncomp_press());
                } else {
                    TE_rp = 2 * STAT_rp - PITOT_rp;
                }
            } else if (loop_cnt < 20*loop_freq) {
                TE_rp -= (fpct)11.5/(fpct)loop_freq; // 1 m/sec Steigen
            } else if (loop_cnt < 40*loop_freq) {
                TE_rp -= (fpct)22.5/(fpct)loop_freq; // 2 m/sec Steigen
            } else if (loop_cnt < 60*loop_freq) {
                TE_rp -= (fpct)34.5/(fpct)loop_freq; // 3 m/sec Steigen
            } else if (loop_cnt < 80*loop_freq) {
                TE_rp += (fpct)16.8/(fpct)loop_freq; // 1.5 m/sec Fallen
            } else if (loop_cnt < 100*loop_freq) {
                TE_rp += (fpct)34.4/(fpct)loop_freq; // 3 m/sec Fallen
            } else if (loop_cnt < 120*loop_freq) {
                TE_rp -= (fpct)46.0/(fpct)loop_freq; // 4 m/sec Steigen
            } else if (loop_cnt < 140*loop_freq) {
                TE_rp -= (fpct)0.0; // 0 m/sec
            } else {
                if (p_configuration == 3) {
                    TE_rp = TEc.compensate_pressure(TEc.get_uncomp_press());
                } else {
                    TE_rp = 2 * STAT_rp - PITOT_rp;
                }
            }
    } else {
	    if (p_configuration == 3) {
		TE_rp = TEc.compensate_pressure(TEc.get_uncomp_press());
	    } else {
		TE_rp = 2 * STAT_rp - PITOT_rp;
	    }
    }

            TE_pressure = TE_rp/(fpct)100.0;

            press_scale += (fpct)1.0;

// Vario FIR Filter to differentiate altitude
            Vario = limit_to(filter.diff_fir(AVS.altitude(TE_pressure, QNH_val)),-20.0f,20.0f);

	    vsynth.TimeTick();
            switch (loop_cnt_mod) {
                case 1:
                    myled = LED_OFF;
                    STAT_pressure /= press_scale;
                    PITOT_pressure /= press_scale;
		    /*
                    AVS.nmea_out(nmea_port,Vario,STAT_pressure,fabs(PITOT_pressure-STAT_pressure)*100.0f
                                 ,AVS.bernulli_tas(PITOT_pressure,STAT_pressure));
				 // ,TE_pressure);
		    */
                    AVS.nmea_out(nmea_port,Vario,STAT_pressure,AVS.dyn_press(PITOT_pressure,STAT_pressure));
                    STAT_pressure = PITOT_pressure = press_scale = (fpct)0.0;
                    break;

                case 2:
                    vsynth.SetVario(Vario);
		    vneedle.SetNeedle(Vario);
                    break;

                case 3:
                    // myled = !myled;
                    if (nmea_cmd.read_sentence()) {
                        cmd = nmea_cmd.analyze_sentence();
                        pc->printf("NMEA CMD:0x%X\n",cmd);
                        switch (cmd) {
                            case 0x535A: // SZ : 0 Offset
                                pc->ungetc('z');
                                break;
                            case 0x5252: // RR : restart Vario
                                pc->ungetc('R');
                                break;
                            case 0x5343: // SC : sawp UART channels
                                pc->ungetc('U');
                                break;
                            case 0x4153: // AS : unlock advanced setting
                                pc->ungetc('A');
                                break;
                            case 0x5247: // RG : re-init GPS receiver
                                pc->ungets("Ii");
                                break;
                            case 17202: // C2
                                pc->ungetc('2');
                                break;
                            case 17203: // C3
                                pc->ungetc('3');
                                break;
                            case 17990: // FF
                                pc->ungetc('F');
                                break;
                            case 21331: // SS
                                pc->ungetc('S');
                                break;
                            case 22598: // XF
                                pc->ungetc('f');
                                break;
                            case 22611: // XS
                                pc->ungetc('s');
                                break;
                            case 22101: // VU
                                pc->ungetc('V');
                                break;
                            case 22084: // VD
                                pc->ungetc('v');
                                break;
                            case 22093: // Mute
                                vsynth.UpDownVolume(-100);
                                break;
                            case 17474: // Deadband On/Off
                                vsynth.dead_band_enabled = !vsynth.dead_band_enabled;
                                break;
                            case 17492: // Tone Mode
                                vsynth.dualtone = !vsynth.dualtone;
                                break;
                            case 5461062: // STF
                                gps_port.printf("$PMTK314,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0*28\r\n"); // GPRMC and GPGGA only
                                break;
                            case 5652818: // Vario
                                gps_port.printf("$PMTK300,500,0,0,0,0*28\r\n"); // one fix every 500 ms
                                break;

                            default:
                                pc->printf("Unknown CMD:%d\n",cmd);
                                break;
                        }
                    }

                    if (pc->readable()) {
                        pc->printf("cmd...\n");
                        c_rxtx = pc->getc();

                        switch (c_rxtx) {

                            case '?':
				pc->printf("BMP280 temperature: TE=%6.1f, STAT=%6.1f, PITOT=%6.1f\n",TE_temperature,STAT_temperature,PITOT_temperature);
                                pc->printf("Commands:\nD/d: deadband on/off\nF/S: faster/slower loop frequency\nf/s: fast/slow FIR on TE\n");
                                pc->printf("V/v: volume up/down\nT/t: dual/intermittend tone\n2/3: 2/3 P-Sensor configuration\n");
                                pc->printf("z:   set zero-offset on P-Sensors\nI/i: (re)initialize GPS receiver\n");
                                pc->printf("R:   restart\nU:   swap UART channels\nA:   unlock Advanced settings\n");
                                pc->printf("x:   dump NVM\ng/o +/-/0: to modify or initialize Vario Gauge gain and offset\n");
                                pc->printf("c:   adjust RTC\n");
                                break;
			    case 'c':
				pc->no_rx_interrupt();
				rtc.adjust_clock(pc);
				pc->printf("System reset ...\n");
				wait_ms(100);
				NVIC_SystemReset();
				break;
			    case 'x':
				if (RTC_present) {
				pc->printf("RTC regs:\n");
				for (i=0;i<8;i++) { pc->printf("%d:%08x ",i,rtc.read_backup_reg(i)); }
				pc->printf("\n"); }
#ifdef AT24C08_NVM
    				if (eeprom_present) {
				pc->printf("EEPROM:\n");
				/**************
				for (i=0;i<8;i++) { pc->printf("%d:%02x%02x%02x%02x ",i,
				  eeprom.byte_read(3+NVM_OFFSET+4*i),eeprom.byte_read(2+NVM_OFFSET+4*i),
				  eeprom.byte_read(1+NVM_OFFSET+4*i),eeprom.byte_read(0+NVM_OFFSET+4*i)
				  ); }
				*****************/
				u32 il;
				for (i=0;i<8;i++) {
				  eeprom.fetch(NVM_OFFSET+4*i,4,&il);
				  pc->printf("%d:%08x ",i,il); }
				pc->printf("\n"); }
#endif
                                break;
                            case 'd':
                                vsynth.dead_band_enabled = false;
                                pc->printf("Dead Band OFF\n");
                                break;
                            case 'D':
                                vsynth.dead_band_enabled = true;
                                pc->printf("Dead Band ON\n");
                                break;
                            case '2':
                                // TEc.present = false;
				p_configuration = 2;
                                pc->printf("Without TE sensor\n");
                                break;
                            case '3':
                                // TEc.present = true;
				p_configuration = 3;
                                pc->printf("With TE sensor\n");
                                break;
                            case 's':
				fir_length_ms = 5000;
                                pc->printf("Vario FIR length: %d ms\n",fir_length_ms);
                                keep_going = false; //re-initi
                                break;
                            case 'f':
				fir_length_ms = 3000;
                                pc->printf("Vario FIR length: %d ms\n",fir_length_ms);
                                keep_going = false; //re-initi
                                break;
                            case 'S':
                                if (loop_freq > 11) {
                                    loop_freq -= 2;
                                }
                            case 'R':
                                pc->printf("new Loop Freq: %d Hz\n",loop_freq);
                                keep_going = false; //re-initi
                                break;
                            case 'F':
                                if (loop_freq < 27) {
                                    loop_freq += 2;
                                }
                                pc->printf("new Loop Freq: %d Hz\n",loop_freq);
                                keep_going = false; //re-initi
                                break;
                            case 'T':
                                vsynth.dualtone = true;
                                pc->printf("Dual Tone ON\n");
                                break;
                            case 't':
                                vsynth.dualtone = false;
                                pc->printf("Dual Tone OFF\n");
                                break;
                            case 'z':
                                // button_pressed();
				button_state = true;
                                pc->printf("Offset to Zero\n");
                                break;
                            case 'V':
                                pc->printf("Vol %d\n",vsynth.UpDownVolume(5));
                                break;
                            case 'v':
                                pc->printf("Vol %d\n",vsynth.UpDownVolume(-5));
                                break;
                            case 'I':
                                gps_port.printf("$PMTK314,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0*28\r\n"); // GPRMC and GPGGA only
                                // wait_ms(200);
                                // gps_port.printf("$PMTK300,500,0,0,0,0*28\r\n"); // one fix every 500 ms
                                // pc->printf("GPS: GPRMC, GPGGA, 500 ms\n");
                                pc->printf("GPS: GPRMC\n");
                                break;
                            case 'i':
                                // gps_port.printf("$PMTK314,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0*28\r\n"); // GPRMC
                                // wait_ms(200);
                                gps_port.printf("$PMTK300,500,0,0,0,0*28\r\n"); // one fix every 500 ms
                                pc->printf("GPS: 500 ms\n");
                                break;
/* adjust gain and offset of Analog Vario Gauge */
                            case 'g': // change gain
				change_vario_gauge_gain = true;
				incr_vario_gauge_gain = 0;
				gate_vario_gauge_change = 5 * loop_freq * readings_per_loop;
				change_vario_gauge_offset = false;
                                break;
                            case 'o': // change offset
				change_vario_gauge_offset = true;
				incr_vario_gauge_offset = 0;
				gate_vario_gauge_change = 5 * loop_freq * readings_per_loop;
				change_vario_gauge_gain = false;
                                break;
                            case '+':
				if (change_vario_gauge_gain) { incr_vario_gauge_gain += 1; }
				if (change_vario_gauge_offset) { incr_vario_gauge_offset += 1; }
                                break;
                            case '-':
				if (change_vario_gauge_gain) { incr_vario_gauge_gain -= 1; }
				if (change_vario_gauge_offset) { incr_vario_gauge_offset -= 1; }
                                break;
                            case '0':
				init_vario_gauge_param = true;
                                break;
/* END adjust gain and offset of Analog Vario Gauge */
                            case '6':
                                TEc.filter = (BMP280_FILTER_COEFF_16 << 2);
                                TEc.set_filter();
                                TEc.print_settings(pc,"TE");
                                break;
                            case '8':
                                TEc.filter = (BMP280_FILTER_COEFF_8 << 2);
                                TEc.set_filter();
                                TEc.print_settings(pc,"TE");
                                break;
                            case '4':
                                TEc.filter = (BMP280_FILTER_COEFF_4 << 2);
                                TEc.set_filter();
                                TEc.print_settings(pc,"TE");
                                break;
#ifndef DAC_OUT
                            case 'w':
                                vsynth.pw -= 0.02f;
                            case 'W':
                                vsynth.pw += 0.01f;
                                VarioSound.write(vsynth.pw);
                                pc->printf("pw: %.3f\n",vsynth.pw);
                                break;
#endif
                            case 'A': // Unlock advanced settings
				enable_deep_settings = true;
                                pc->printf("advanced settings\n");
                                break;
                            case 'U': // MOVE
                                pc->printf("swap UART channels ...\n");
                                tmp_swp = pc;
                                pc = nmea_port;
                                nmea_port = tmp_swp;
                                vsynth.set_channel(pc);
                                nmea_cmd.set_channel(nmea_port);
                                keep_going = false; //re-initi
                                pc->printf("swap UART channels completed\n");
                                break;
                            default:
                                pc->printf("in: 0x%0X ??\n",(int)c_rxtx);
                                break;
                        }
                    }
                    break;

                case 0:
                    myled = LED_ON;
                    // sentence_p = gps_in.read_sentence();
                    while ((sentence_p = gps_in.read_sentence()) != NULL) {
			if(strstr(sentence_p,"$GPVTG,") != '\0') { pc->ungets("I"); pc->ungets("i"); }
                        nmea_port->printf("%s\n",sentence_p);
                    }
                    break;

                default:
                    if ((s2f=Speed2fly) != s2f_last) {
                        s2f_last = s2f;
                        if (s2f) {
			    /* not yet implemented */
                            pc->printf("Speed_to_fly mode\n");
                        } else {
                            pc->printf("Vario mode\n");
                        }
                    }

		    /* Abuse STF switch to try different FIR length in flight
                    if ((s2f=Aux_Switch) != s2f_last) {
                        s2f_last = s2f;
                        if (s2f) {
			    fir_length_ms = 3000;
			    vsynth.AckTone(2000,2);
                            pc->printf("Fast\n");
                        } else {
			    fir_length_ms = 5000;
			    vsynth.AckTone(1000,2);
                            pc->printf("Slow\n");
                        }
			keep_going = false;
                    }
		    **********************************/

                    cnt_now = Rotary_Enc.getPulses();
                    if (cnt_now != prev_count) {
                        pc->printf("Vol %d\n",vsynth.UpDownVolume(imax(1,vsynth.UpDownVolume(0)/10) * (cnt_now-prev_count)));
                        // pc->printf("Rotary Encoder pulses: %i\n", cnt_now);
                        prev_count = cnt_now;
                    }
#ifdef REPORT_LOOP_TIMES
                    pc->putc('\n');
#endif
#ifdef REPORT_SENSOR_TEMP
                    pc->printf("Sensor temp [C] TE: %.1f, STAT: %.1f, PITOT: %.1f\n",TE_temperature,STAT_temperature,PITOT_temperature);
#endif
                    break;
            }


            if (button_state) { // press the BLUE button on the Nucleo or the K0 button on the Arch Max to take new zero offsets
                button_state = false;
                avg_cnt = ZERO_OFFS_AVG_CNT;
                pc->printf("Offset calc:");
                STAT_avg=PITOT_avg=0;
                button_flag = true;
            }

	    if (toggle_audio_mode) {
	      toggle_audio_mode = false;
	      vsynth.dualtone = !vsynth.dualtone;
	      pc->printf("Dual Tone O");
	      if (vsynth.dualtone) pc->printf("N\n");
	      else pc->printf("FF\n");
	    }

            if (button_flag) {
                if (avg_cnt > 0) {
                    pc->printf(" %d",avg_cnt);
                    STAT_avg += STAT_rp;
                    PITOT_avg += PITOT_rp;
                    avg_cnt -= 1;
                } else {
                    button_flag = false;
                    p_avg = (STAT_avg+PITOT_avg)/2.0f;
                    pc->printf("\naverage pressure: %.2f Pa\n",p_avg/(fpct)ZERO_OFFS_AVG_CNT);
                    STATc.zero_offs = (STAT_avg - p_avg)/(fpct)ZERO_OFFS_AVG_CNT;
                    PITOTc.zero_offs = (PITOT_avg - p_avg)/(fpct)ZERO_OFFS_AVG_CNT;
                    pc->printf("Zero-Offsets [Pa]: STAT=%.2f PITOT=%.2f\n",STATc.zero_offs,PITOTc.zero_offs);
        pc->printf("Vario Gauge: gain=%.4f offset=%.4f\n",vneedle.GetGain(),vneedle.GetZero());

		    nvm.v_long[0] = 0x12345678;
                    nvm.v_float[1] = STATc.zero_offs;
                    nvm.v_float[2] = PITOTc.zero_offs;
		    if (RTC_present) {
        pc->printf("write RTC\n");
		      for (i=0; i<3; i++) { rtc.write_backup_reg(i,nvm.v_long[i]); }
#ifdef AT24C08_NVM
		    }
		   //  else
		    if (eeprom_present) {
        pc->printf("write EEPROM\n");
		    eeprom.store(NVM_OFFSET,3,&nvm.v_long[0]);
#endif
		    }

                    sprintf(message_buf,"zero set: %.2f %.2f",STATc.zero_offs,PITOTc.zero_offs);
                    AVS.nmea_alert(nmea_port, info, message_buf);
                }
            }

/* adjust gain and offset of Analog Vario Gauge */
	if (gate_vario_gauge_change > 0) {
	  gate_vario_gauge_change -= 1;
	if (enable_deep_settings && (gate_vario_gauge_change == 0)) {
	  if (change_vario_gauge_gain) {
	    vario_needle_gain = 0.001 * (float)incr_vario_gauge_gain +  vneedle.GetGain();
	    incr_vario_gauge_gain = 0;
	  }
	  if (change_vario_gauge_offset) {
	    vario_needle_offs = 0.01 * (float)incr_vario_gauge_offset +  vneedle.GetZero();
	    incr_vario_gauge_offset = 0;
	  }
	  if (init_vario_gauge_param) {
	    vario_needle_offs = 0.51;
	    vario_needle_gain = 0.094;
	  }
	vneedle.SetZero(vario_needle_offs);
	vneedle.SetGain(vario_needle_gain);
        pc->printf("Vario Gauge: gain=%.4f offset=%.4f\n",vneedle.GetGain(),vneedle.GetZero());
	nvm.v_float[0] = vario_needle_gain;
	nvm.v_float[1] = vario_needle_offs;
	if (RTC_present) {
	  rtc.write_backup_reg(4,nvm.v_long[0]);
	  rtc.write_backup_reg(5,nvm.v_long[1]);
	}
#ifdef AT24C08_NVM
	if (eeprom_present) {
	  eeprom.store(NVM_OFFSET+16,2,&nvm.v_long[0]);
	}
#endif
	change_vario_gauge_gain = change_vario_gauge_offset =
	init_vario_gauge_param = false;

	}}
/* END adjust gain and offset of Analog Vario Gauge */


        } while (keep_going);
        // finish last measure cycle
        // wait as long as device is still busy measuring before we read the data
	for (w_cnt=0; (w_cnt < 20) && (PITOTc.is_busy() || STATc.is_busy() || TEc.is_busy()); w_cnt++) {
            pc->putc('w');
            wait_ms(5);
        }
        // read data from pressure sensor
        // measure cycle was started in the previous loop
        TEc.unload_raw_data();
        STATc.unload_raw_data();
        PITOTc.unload_raw_data();
        vsynth.SetSilence();
        pc->printf("\nre-starting ...\n");
    }
}

