#ifndef FILTERS_INCLUDE_H
#define FILTERS_INCLUDE_H
#ifdef TESTBENCH
#include <stdlib.h>
#include <stdio.h>
#endif
#include "my_types.h"

class filters {
private:
fpct raw_sum;
int io_index;
int mid_index;
fpct * filter_array;
int filter_length;
int array_length;
int sample_rate;
int invalid_data_cnt;

public:

filters(int arr_length,int flt_length,int rate,fpct init_p=0.0f)
{
    
    int i;
 
    array_length = arr_length;

#ifdef TESTBENCH
    filter_array = (fpct *)malloc(array_length*sizeof(fpct));
    printf ("new avs_c: %d array_length, %d half_size\n",array_length,flt_length);
#else
    filter_array = new fpct[array_length];
#endif
    io_index = 0;
    mid_index = flt_length;
    invalid_data_cnt = array_length;
    filter_length = flt_length;
    sample_rate = rate;
    for (i=0;i<array_length;i++) {
      filter_array[i] = init_p;
      }
    raw_sum = (fpct)init_p;
    // printf ("new filters with %d taps, initv: %.2f\n",array_length,init_p);
}

~filters()
{
#ifdef TESTBENCH
    free(filter_array);
    printf ("filters destructed\n");
#else
    delete [] filter_array;
#endif
    array_length = 0;
    filter_length = 0;
}

/*** depriciated *********************************
fpct vario_filter(fpct altitude);
fpct pressure_filter(fpct p);
**************************************************/

fpct diff_fir(fpct altitude);
fpct avg_fir(fpct p);

#ifdef TESTBENCH
void pr_array();
#endif
};

#endif // FILTERS_INCLUDE_H



