#include "mbed.h"
#include "ext_ser.hpp"
#include <CriticalSectionLock.h>

void Ext_Serial::catch_rx_interrupt(void)
{
    // Serial::attach(this, &Ext_Serial::direct_push, Serial::RxIrq);
    Serial::attach(callback(this, &Ext_Serial::direct_push), Serial::RxIrq);
}

void Ext_Serial::no_rx_interrupt(void)
{
    Serial::attach(NULL, Serial::RxIrq);
}

void Ext_Serial::direct_push(void)
{
    while (Serial::readable()) ungetc(Serial::getc());
}

void Ext_Serial::ungetc(const char c)
{
  {
    CriticalSectionLock lock;
    if (n_c < depth) {
      *csp++ = c;
      n_c += 1; }
  }
  return;
}

void Ext_Serial::ungets(const char * s)
{
    const char * p=s;
    while (*p) { p++; }
    while (p != s) ungetc(*--p);
}

char Ext_Serial::getc(void)
{
    if (n_c > 0) {
        n_c -= 1;
        return (*--csp);
    } else {
        return (Serial::getc());
    }
}

bool Ext_Serial::readable(void)
{
    if (n_c > 0) return true;
    
    return (Serial::readable());
}

