#ifndef AVS_INCLUDE_H
#define AVS_INCLUDE_H
#ifdef TESTBENCH
#include <stdlib.h>
#include <stdio.h>
#endif
#include "my_types.h"

enum Severity
{
    info,
    warning,
    err,
    failure
};

class avs_c {
private:
int nmea_checksum(char *s);

public:

avs_c()
{
}

~avs_c()
{
}

#ifndef TESTBENCH
fpct dyn_press(fpct P, fpct S);
void nmea_out(char *buf, fpct xv, fpct stat, fpct dynp, fpct xtas, fpct totp);
void nmea_out(Serial *channel, fpct xv, fpct stat, fpct dynp, fpct xtas, fpct totp);
void nmea_out(char *buf, fpct xv, fpct stat, fpct dynp, fpct xtas);
void nmea_out(Serial *channel, fpct xv, fpct stat, fpct dynp, fpct xtas);
void nmea_out(char *buf, fpct xv, fpct stat, fpct dynp);
void nmea_out(Serial *channel, fpct xv, fpct stat, fpct dynp);
void nmea_alert(Serial *channel, Severity lev, char * message);
#endif
fpct sealevel(fpct P, fpct A);
fpct altitude(fpct P, fpct P0);
fpct bernulli_ias(fpct pitot, fpct stat, bool clip=true);
fpct bernulli_tas(fpct pitot, fpct stat, bool clip=true);
};

#endif // AVS_INCLUDE_H



