/**
 * =============================================================================
 * access class for AT24C08 on-volatil memory
 * =============================================================================
 */
 
#ifndef AT24C08_H
#define AT24C08_H

#define AT24C08_PAGE_SIZE  16

#include "mbed.h"
typedef uint8_t u8;/**< used for unsigned 8bit */


/**
 * Constructor(I2C bus sda pin, I2C bus scl pin, Device address)
 */
class at24c08{
public:
    at24c08(PinName sda, PinName scl, u8 dev_addr=0xA0, unsigned bus_speed=400000);
    
    //Destructor
    ~at24c08();
    
    void store(unsigned w_addr,unsigned nb,u8 *source);
    void store(unsigned w_addr,unsigned nl,long *source);
    void fetch(unsigned w_addr,unsigned nb,u8 *dest);
    void fetch(unsigned w_addr,unsigned nl,long *dest);
private:
    void byte_write(unsigned w_addr,u8 d);
    u8 byte_read(unsigned w_addr);
    I2C i2c_bus;
    u8 i2c_addr;
};
#endif

