/**
 * =============================================================================
 * access class for AT24C08 non-volatil memory
 * =============================================================================
 */
 
#include "at24c08.h"
#include "mbed.h"

/**
 * Constructor(I2C bus sda pin, I2C bus scl pin, Device address)
 */
at24c08::at24c08(PinName sda, PinName scl, u8 dev_addr, unsigned bus_speed)
  : i2c_bus(sda, scl)
  {
    i2c_bus.frequency(bus_speed);
    i2c_addr = dev_addr & 0xF8;
  }
    
    //Destructor
at24c08::~at24c08()
  {
  }

void
at24c08::byte_write(unsigned w_addr,u8 d)
{
    char cmd[2];

    cmd[0] = w_addr & 0xFF;
    u8 mem_addr = ((w_addr & 0x300) >> 7) | i2c_addr;
    cmd[1] = d;
    i2c_bus.write(mem_addr,cmd,2);
    wait_ms(5); // wait until write cycle is complete
}

u8
at24c08::byte_read(unsigned w_addr)
{
    char cmd[2];

    cmd[0] = w_addr & 0xFF;
    u8 mem_addr = ((w_addr & 0x300) >> 7) | i2c_addr;
    i2c_bus.write(mem_addr,&cmd[0],1); // ,true);
    i2c_bus.read(mem_addr,&cmd[1],1);

    return(cmd[1]);
}

int xmin(int a, int b) { return a < b ? a : b; }

void
at24c08::fetch(unsigned address,unsigned len,u8 *buffer)
{
  int lx;
  char cmd[2];
  u8 mem_addr;

  while ((lx = xmin(AT24C08_PAGE_SIZE - (address % AT24C08_PAGE_SIZE),len)) > 0)
    {
    cmd[0] = address & 0xFF;
    cmd[1] = 0;
    mem_addr = ((address & 0x300) >> 7) | i2c_addr;
    i2c_bus.write(mem_addr,cmd,1);
    i2c_bus.read(mem_addr,(char *)buffer,lx);
    address += lx;
    buffer += lx;
    len -= lx;
    }
}

void
at24c08::fetch(unsigned w_addr,unsigned nl,long *dest)
{
  u8 *p = (u8 *) dest;

  fetch(w_addr,nl*4,p);
}

void
at24c08::store(unsigned address,unsigned len,u8 *source)
{
  int lx, i;
  char cmd[AT24C08_PAGE_SIZE+1];
  char mem_addr;

  while ((lx = xmin(AT24C08_PAGE_SIZE - (address % AT24C08_PAGE_SIZE),len)) > 0)
    {
    cmd[0] = address & 0xFF;
    mem_addr = ((address & 0x300) >> 7) | i2c_addr;
    address += lx;
    len -= lx;
    lx += 1;
    for (i=1;i < lx;i++) {cmd[i] = *source++;}
    i2c_bus.write(mem_addr,cmd,lx);
    wait_ms(5); // wait until write cycle is complete
    }
}

void
at24c08::store(unsigned w_addr,unsigned nl,long *source)
{
  u8 *p = (u8 *) source;

  store(w_addr,nl*4,p);
}


