
#include "VarioDisplay.hpp"

float Clamp(const float value, const float min, const float max)
{
  return (value < min)
    ? min
    : ((value > max)
       ? max : value);
}

VarioDisplay::VarioDisplay(PinName needle_pin,
  float _min_scale,
  float _max_scale,
  float _offset,
  float _gain,
  unsigned int _pw_us) : needle_(needle_pin)
{
  min_scale = _min_scale;
  max_scale = _max_scale;
  offset    = _offset;
  gain      = _gain;
  int pw_us = _pw_us;
  needle_.period_us(pw_us);
  needle_.write(offset);
}

void
VarioDisplay::SetNeedle(float vario)
{
  needle_.write(offset+(Clamp(vario,min_scale,max_scale)*gain));
}

void
VarioDisplay::SetZero(float zero_val)
{
  offset = zero_val;
}

float
VarioDisplay::GetZero(void)
{
  return (offset);
}

void
VarioDisplay::SetGain(float gain_val)
{
  gain = gain_val;
}

float
VarioDisplay::GetGain(void)
{
  return(gain);
}

