#include "mbed.h"

#define SERIAL_TX PA_9
#define SERIAL_RX PA_10
Serial pc(SERIAL_TX, SERIAL_RX, 115200);

int main(void)
{
    time_t t;
    struct tm *tx;

    pc.printf("++++++++++++++++++++++\nsizeof(time_t) = %d\n++++++++++++++++++++++\n",sizeof(time_t));

    time(&t);
    pc.printf("read RTC: %u\n",(int)t);
    tx = localtime(&t);
    pc.printf("ctime: %s", ctime(&t));
    pc.printf("T: %d:%d:%d D: %d.%d.%d X: %d\n",
              tx->tm_hour,tx->tm_min,tx->tm_sec,
              tx->tm_mday,tx->tm_mon+1,tx->tm_year+1900,
              tx->tm_isdst);

    pc.printf("t = 0\n");
    t = 0;
    tx = localtime(&t);
    pc.printf("ctime: %s", ctime(&t));
    pc.printf("T: %d:%d:%d D: %d.%d.%d X: %d\n",
              tx->tm_hour,tx->tm_min,tx->tm_sec,
              tx->tm_mday,tx->tm_mon+1,tx->tm_year+1900,
              tx->tm_isdst);

    pc.printf("loop start\n");
    while (1) {
        tx = localtime(&t);
        pc.printf("ctime: %s", ctime(&t));
        pc.printf("T: %d:%d:%d D: %d.%d.%d X: %d\n",
                  tx->tm_hour,tx->tm_min,tx->tm_sec,
                  tx->tm_mday,tx->tm_mon+1,tx->tm_year+1900,
                  tx->tm_isdst);
        wait(1);
        t += 1;
    }
}
