#include "mbed.h"
#include "Servo.h"
#include "TSISensor.h"

#define WAITTIME 0.2

/* 
*   Written by: Bresdin O'Malley 2015
*   Servo control for shield NMHU (New Mexico Highlands University) KL-46Z.
*   This will control two servos ~ Using capacitive touch sensor to control servo speed

*/

Servo myservo1(PTC9);
Servo myservo2(PTC8);

TSISensor tsiScaling;
float tempValue;

int main() { 
while(true) {  
    
    tempValue = tsiScaling.readPercentage(); 
        
    if(tempValue > 0)
    {
        //change speed of servos
        myservo1.write(tempValue);
        myservo2.write(tempValue);
    }
    else
    {
        myservo1.write(0);
        myservo2.write(0);
    }
    wait(WAITTIME);
    }
}