#include "mbed.h"
#include "SLCD.h"

#define PROGNAME "Plant Vital Sign Detector v1 v3\r\n"
#define HIGH 1
#define LOW 0
#define PIN_2_555 D2
#define PIN_3_555 D3
#define PIN_3_CLONE LED_GREEN
#define LEDON LOW
#define LEDOFF HIGH
#define OUTPULSELEN 100 // ms

#define DATATIME 100
#define SERIALSPEED 57600
#define MAX_OUT 1500 // ms
#define MIN_OUT 500
#define ABORTTIME 3500
#define INPUTSTART 1
#define DATARATE 1000 // ms time between data takes.
#define LCDLEN 10

#define MAXTIME 2
#define TIMERSTATE 0
#define CHECKMOISTURE 1
#define MOREMOISTURE 2
#define CHECKLIGHT 3
#define MORELIGHT 4
#define LESSLIGHT 5

#define LIGHTMIN .100 //there is too much light
#define LIGHTMAX .900 // there is not enough light

#define WATERMAX 1500 //Do not water. There is Moisture
#define WATERMIN 3000 //Water, there is no moisture

#define ML "MORE LIGHT"
#define LL "LESS LIGHT"
#define MW "MORE WATER"


// this constant won't change:
DigitalOut oneShotIn (PIN_2_555); 
// the pin that the pushbutton is attached to
DigitalIn oneShotOut (PIN_3_555);
DigitalOut ledPin(PIN_3_CLONE);       // the pin that the LED is attached to
AnalogIn LightSensor(PTE22); // define light sensor

Serial pc(USBTX, USBRX);
SLCD slcd; 
Timer milliTimer; 

int PgmState;
long oneShotLen;
long timeOut = ABORTTIME;
long nextDataTake = DATARATE;
long oneShotBegin;
long oneShotEnd;
// Variables will change:
int buttonPushCounter = 0;   // counter for the number of button presses
int buttonState = 0;         // current state of the button
int lastButtonState = 0;     // previous state of the button

float lightVal;             //value of the light sensor
unsigned short lightWord;  

int timerChip;
char lcdData[LCDLEN];

void LCDMess(char *lMess){
        slcd.Home();
        slcd.clear();
        slcd.printf(lMess);
} 
void pulseOut (long pulseLen){
    oneShotIn.write(LOW);
    wait_us(pulseLen);
    oneShotIn.write(HIGH);
}

void setup() {
  
  // initialize serial communication:
  oneShotIn.write(HIGH);
  oneShotOut.mode(PullNone);
  milliTimer.start();
  milliTimer.reset();
}

void readLightSensor() {
    lightVal = LightSensor.read();
    lightWord = LightSensor.read_u16();
    pc.printf("LS => %1.3f %5d \r\n", lightVal, lightWord);
    
    if(lightVal <= LIGHTMIN) {
        PgmState = LESSLIGHT;
    }
    else if(lightVal >= LIGHTMAX) {
        PgmState = MORELIGHT;
    }
}

void readTimerChip() {
    timerChip = oneShotOut.read();
   // pc.printf();
   /****
   #define  WATERMAX 1500 //Do not water. There is Moisture
    #define WATERMIN 3000 //Water, there is no moisture
 ***/
    
   if(timerChip >= WATERMAX) {
        //Do not water move to check light
        PgmState = CHECKLIGHT; 
   }
   else if(timerChip <= WATERMIN) {
        //Tell pc to water then move to check light
        pc.printf(MW);
        PgmState = CHECKLIGHT; 
   }
}

int main(){
    
    pulseOut(OUTPULSELEN);
    //LCDMess(PROGNAME);
    setup();
    PgmState = TIMERSTATE; 
    int count = 0;
    
    while (true) {
        switch(PgmState) {
            case TIMERSTATE:
            //loops until timer => MAXTIME
            //Go on to CHECKMOISTURE
            if(milliTimer.read_ms() >= MAXTIME) {
                milliTimer.reset();
                PgmState = CHECKMOISTURE; 
            }
            break;
            case CHECKMOISTURE:
            //call readTimerChip();
                readTimerChip();
            break;
            case MOREMOISTURE:
            //Output to PC "NEEDS WATER"
            //Change state to CHECKLIGHT
                pc.printf(MW);
            break;
            case CHECKLIGHT:
            //call readLightSensor
                readLightSensor();
            break;
            case MORELIGHT:
            //output to PC "MORE LIGHT"
            //CHange state to TIMERSTATE
                pc.printf(ML); 
                PgmState = TIMERSTATE;   
            break;
            case LESSLIGHT:
            //OP to PC "LESS LIGHT"
            //Chane State to TIMERSTATE
                pc.printf(LL);
                PgmState = TIMERSTATE;
            break;
            
        }
        count++;
        pc.printf("d",count);
        wait(DATATIME);
    }
}