#include "mbed.h"
#include "MMA8451Q8.h"
#include "SLCD.h"

#define BLINKTIME   0.7
#define RELAYON     0
#define RELAYOFF    1
#define LEDDELAY    0.75
#define WAITDELAY   3.0
#define LCDLEN      10

#define REG_WHO_AM_I      0x0D
#define XYZ_DATA_CFG      0x0E

#define REG_OUT_X_MSB     0x01
#define REG_OUT_Y_MSB     0x03
#define REG_OUT_Z_MSB     0x05
#define REG_PULSE_SRC     0x22
#define REG_PULSE_CFG     0x21

#define REG_PULSE_THSZ    0x25
#define REG_PULSE_TMLT    0x26
#define REG_PULSE_LTCY    0x27

#define REG_CTRL_REG4   0x2D
#define REG_CTRL_REG5   0x2E

#define REG_DATA_THSZ    0x08
#define REG_DATA_TMLT    0x26
#define REG_DATA_LTCY    0x27

#define MAX_2G            0x00
#define MAX_4G            0x01
#define MAX_8G            0x02

//#define PRINTDBUG
// Accelerometer SPI pins
#if   defined (TARGET_KL25Z) || defined (TARGET_KL46Z)
  PinName const SDA = PTE25;
  PinName const SCL = PTE24;
#elif defined (TARGET_KL05Z)
  PinName const SDA = PTB4;
  PinName const SCL = PTB3;
#else
  #error TARGET NOT DEFINED
#endif

#define MMA8451_I2C_ADDRESS (0x1d<<1)
 
Ticker ledBlink; // timinginterrupt for RED led
InterruptIn mybutton(PTC3);  //push botton with internal pullup
DigitalOut myled(LED_RED); // red led
DigitalOut relay(LED_GREEN); // green led

MMA8451Q acc(SDA, SCL, MMA8451_I2C_ADDRESS);
 
float delay = WAITDELAY;
int relayState = RELAYOFF;
int outState = false;
SLCD slcd; //define LCD display
char LCDMessages[2][LCDLEN] = {"TRUE", "FALS"};


void LCDMess(char *lMess, float dWait){
        slcd.Home();
        slcd.clear();
        slcd.printf(lMess);
        wait(dWait);
} 
void LCDMessNoDwell(char *lMess){
        slcd.Home();
        slcd.clear();
        slcd.printf(lMess);
} 


void LEDBlinker(){  // RED LED interrupt
    outState = !outState; 
    myled.write(outState);
}
        
    
void pressed() // button intterupt
{
    relayState = !relayState;
    relay.write(relayState);
}

int main()
{
    uint8_t regData = MAX_4G; 
    uint8_t latchData = 0x40; //0b01000000; //for pulse config register
    uint8_t axisData = 0x10; //0b00010000;
    char lcdData[LCDLEN];
    
    myled.write(outState);
    relay.write(relayState);
    
// set up interrrupts to be used later for taps
    mybutton.rise(&pressed);
    mybutton.mode(PullNone);
// set up interrrupts to be used later for taps
    ledBlink.attach(&LEDBlinker, LEDDELAY);
    
// Check to see if accerlometer is alive and well
    acc.setGLimit(MAX_2G); // For now set to 2g
    acc.readRegs(XYZ_DATA_CFG, &regData, 1);
    sprintf (lcdData,"%x",regData); // Note displaying in hexidecimal
    LCDMess(lcdData,BLINKTIME);
    acc.readRegs(REG_WHO_AM_I, &regData, 1);
    sprintf (lcdData,"%x",regData);
    LCDMess(lcdData,BLINKTIME); 
    
    while (true) { 

    // Read Pulse Source Data and check to see if things have been set
        acc.readRegs(REG_PULSE_CFG, &regData, 1);  // check it
        sprintf (lcdData,"%x",regData);
        LCDMess(lcdData,BLINKTIME); 
        
        acc.setPulseConfiguration(latchData, axisData); // write the data
        acc.readRegs(REG_PULSE_CFG, &regData, 1);  // check it
        sprintf (lcdData,"%x",regData);
        LCDMess(lcdData,BLINKTIME); 
        
        //send address 
        acc.setRegisterInStandby(REG_PULSE_THSZ, REG_DATA_THSZ);
        acc.setRegisterInStandby(REG_PULSE_TMLT, REG_DATA_TMLT);
        acc.setRegisterInStandby(REG_PULSE_LTCY, REG_DATA_LTCY);
        
        acc.setRegisterInStandby(REG_CTRL_REG4, 0x08);
        acc.setRegisterInStandby(REG_CTRL_REG5, 0x08);

        acc.readRegs(REG_PULSE_SRC, &regData, 1);
        sprintf (lcdData,"%x",regData);
        LCDMess(lcdData,BLINKTIME); 
        
        LCDMessNoDwell(LCDMessages[relayState]);  
        wait(delay);
    }
}
