// Yarrduino
// Copyright 2013, 2014, J. Bolton
// This program is redistributable under the GNU General Public License, version 3.

#include "mbed.h"

// For Freescale FRDM-KL25Z target.

Serial pc(USBTX, USBRX);

#define USE_RGB

#ifdef USE_RGB
PwmOut r (LED_RED);
PwmOut g (LED_GREEN);
PwmOut b (LED_BLUE);
#else
#define LED_OFF 1
#define LED_ON 0
DigitalOut myled(LED1);
#endif
enum char_class {
    LETTER = 0,
    NUMBER = 1,
    PUNCTUATION = 2    
};

enum char_class color = LETTER;

void led_off(void)
{
#ifdef USE_RGB
    r = 1.0;
    g = 1.0;
    b = 1.0;
#else
    myled = LED_OFF;
#endif
}

void led_on(void)
{
#ifdef USE_RGB
    if (color == NUMBER) {
        r = 0;
        g = 1.0;
        b = 1.0;
    } else if (color == PUNCTUATION){
        r = 1.0;
        g = 1.0;
        b = 0;
    } else {
        // hot pink, because RGB LED.
        r = 1.0 - (90.0/255.0); // 255
        g = 1.0 - (255.0/255.0); // 105
        b = 1.0 - (90.0/255.0); // 180
    }
#else
    myled = LED_ON;
#endif
}

char buffer[128];
int bufindex;
int debugSerial = 1;

//?{}[];':"^\|&*()^%$#@!`~,.;:

struct xlate {
    char ascii;
    char *morse;
};

struct xlate letters[] = {
    { 'A', ".-" },
    { 'B', "-..." },
    { 'C', "-.-." },
    { 'D', "-.." },
    { 'E', "." },
    { 'F', "..-." },
    { 'G', "--." },
    { 'H', "...." },
    { 'I', ".." },
    { 'J', ".---" },
    { 'K', "-.-" },
    { 'L', ".-.." },
    { 'M', "--" },
    { 'N', "-." },
    { 'O', "---" },
    { 'P', ".--." },
    { 'Q', "--.-" },
    { 'R', ".-." },
    { 'S', "..." },
    { 'T', "-" },
    { 'U', "..-" },
    { 'V', "...-" },
    { 'W', ".--" },
    { 'X', "-..-" },
    { 'Y', "-.--" },
    { 'Z', "--.." }
};

struct xlate numbers[] = {
    { '1', ".----" },
    { '2', "..---" },
    { '3', "...--" },
    { '4', "....-" },
    { '5', "....." },
    { '6', "-...." },
    { '7', "--..." },
    { '8', "---.." },
    { '9', "----." },
    { '0', "-----" },
};

#define APOSTROPHE 39

struct xlate puncs[] = {
    { '.', ".-.-.-" },
//char *sk = "...-.-";
    { ',', "--..--" },
    { '?', "..--.." },
    { APOSTROPHE, ".----." },
    { '-', "-....-" },
//char *fraction = "-..-." },
    { '(', "-.--.-" },
    { ')', "-.--.-" },
    { '"', ".-..-." },
    { '!', "-.-.--" },
    { '/', "-..-." },
    { 0, 0 }
};


char *xlate_morse(char c)
{
    char i;

    if (c <= 'z' && c >='a') {
        color = LETTER;
        return letters[c-'a'].morse;
    }

    if (c <= 'Z' && c >= 'A') {
        color = LETTER;
        return letters[c-'A'].morse;
    }

    if (c <= '9' && c >= '0') {
        color = NUMBER;
        return letters[c-'0'].morse;
    }

    for (i=0; puncs[i].ascii; i++) {
        color = PUNCTUATION;
        if (puncs[i].ascii == c) {
            return puncs[i].morse;
        }
    }

    return (char *)0;
}

int worddelay = 500;
int glyphdelay = 300;
int ditdelay = 200;
int dahdelay = 600;
int pulsedelay = 100;

void delay(int ms)
{
    wait_ms(ms);
}

void write_morse(char buf[], int len)
{
    char *outbuf;

    led_off();

    for (int i=0; i<len; i++) {
        if (pc.readable()) {
            break;
        }
        if (buf[i] == ' ') {
            delay(worddelay);
        } else {
            outbuf = xlate_morse(buf[i]);
            pc.printf("%c %s\r\n", buf[i], outbuf);

            for (int j = 0; outbuf[j]; j++) {
                led_on();
                delay((outbuf[j] == '-') ? dahdelay : ditdelay);
                led_off();
                delay(pulsedelay);
            }
            delay(glyphdelay);
        }
    }
}


void read_buffer(char buf[], int &idx, int maxsize)
{
    int inchar;
    idx = 0;
    pc.printf("enter new message\r\n");
    for (;;) {
        while (!pc.readable()) { } ;

        inchar = pc.getc();

        if (debugSerial) {
            pc.printf("read: %c", inchar);
            pc.printf(" current index: %d\r\n", idx);
        }

        if (inchar != '|') {
            buf[idx++] = inchar;
        }

        if ((idx == maxsize-1) || inchar == '|') {
            buf[idx] = (char) 0;
            pc.printf("received: %d bytes.\r\n", idx);
            pc.printf("%s\r\n", buf);
            return;
        }
    }
}

void loop()
{
    if (pc.readable() > 0) {
        read_buffer(buffer, bufindex, sizeof(buffer));
    }

    write_morse(buffer, bufindex);
}

int main()
{
    led_off();

    strcpy(buffer, "yarr, matey!");
    bufindex = 12;

    while(1) {
        loop();
    }
}