#include "mbed.h"
#include "ws2811BitBang.h"
#include "ColorConversion.h"

#define NLED (50*6)

DigitalIn button(USER_BUTTON);

DigitalOut boardLED(LED1);

DigitalOut ws2811Data(PA_8);

uint8_t bufferRGB[NLED*3];

int bufferHS0[NLED*2]; //hue & saturation; value is constant. all variables are fixed precision with scale factor 1000.
int bufferHS1[NLED*2]; //double buffer, for manipulation & swap
#define CVALUE 1000


#define max(a,b) ((a)>=(b)?(a):(b))

    
void fillHS0(int hue, int saturation,int hinc){
    int hadd=0;
    for(size_t i=0;i<NLED;i++){
        bufferHS0[2*i]=(hue+hadd)%360000;
        bufferHS0[2*i+1]=saturation;
        hadd+=hinc;
    }
}

/*
I made up this shimmer function as I went along; the idea is to make the lights whiteish (low saturation) most of the time
but occasionally have local patches of lights shimmer with color in a way that travels along the string of lights in a wave
and slowly settles down. 1/splashArrival is the probability that a splash of color will be added to the chain during this
call.
*/
void shimmer(int *buf0, int *buf1, size_t len, 
             int splashArrival = 10,
             int restingSaturation=0,
             int restingWeight=1,
             int neighborWeight=99){
    int totalWeight = restingWeight+neighborWeight;
    int event = rand() % splashArrival;
    if(event==0){
        int led = rand() % (len-5);
        int hue = rand() % (10*360000);
        int sat = 600;//rand() % 1000;
        for(size_t i=0;i<5;i++){
            buf0[2*(led+i)] = hue;
            buf0[2*(led+i)+1]=sat;
        }
    }
    for(size_t i=0;i<len;i++){
        int hl,hc,hr,sl,sc,sr;
        if(i==0){
            hl=buf0[2*(len-1)];
            sl=restingSaturation;
            hr=buf0[2*(i+1)];
            sr=buf0[2*(i+1)+1];
        }else if(i==len-1){
            hl=buf0[2*(i-1)];
            sl=buf0[2*(i-1)+1];
            hr=buf0[0];
            sr=restingSaturation;
        }else{
            hl=buf0[2*(i-1)];
            sl=buf0[2*(i-1)+1];
            hr=buf0[2*(i+1)];
            sr=buf0[2*(i+1)+1];
        }
        hc = buf0[2*i];
        sc = buf0[2*i+1];
        buf1[2*i] = (((2*hl+hc+2*hr)/5)*99+300000*1)/100;
        //printf("baz: %d\n\r",buf1[2*i]);
        buf1[2*i+1]=(max(sl,max(sc,sr))*neighborWeight+restingSaturation*restingWeight)/totalWeight;
    }
}

int main() {
    
    int hue = 0;
    int arrival=1;
    fillHS0(hue,1000,60000);
    while(true){
        if(!button){
            arrival=1;
        }
        shimmer(bufferHS0,bufferHS1,NLED,arrival);
        convertHSVtoRGB(bufferHS1,bufferRGB,NLED,CVALUE);
        sendBuffer(bufferRGB,NLED,ws2811Data);
        boardLED = !boardLED;
    
        shimmer(bufferHS1,bufferHS0,NLED,arrival);
        convertHSVtoRGB(bufferHS0,bufferRGB,NLED,CVALUE);
        sendBuffer(bufferRGB,NLED,ws2811Data);
        boardLED = !boardLED;
        
        if(arrival < 10){
            arrival++;
        }
    }
}
