#include "ws2811BitBang.h"

static inline void send0(DigitalOut& ws2811Data){
    ws2811Data=1;
    WAIT0H();
    ws2811Data=0;
    WAIT0L();
}
static inline void send1(DigitalOut& ws2811Data){
    ws2811Data=1;
    WAIT1H();
    ws2811Data=0;
    WAIT1L();
}

static inline void sendByte(uint8_t b, DigitalOut& ws2811Data){
    for(int i=0;i<8;i++){
        if(b & (uint8_t)0x80){
            send1(ws2811Data);
        }else{
            send0(ws2811Data);
        }
        b = b << 1;
    }
}

static inline void sendLED(uint8_t red, uint8_t green, uint8_t blue,DigitalOut& ws2811Data){
    sendByte(red,ws2811Data);
    sendByte(green,ws2811Data);
    sendByte(blue,ws2811Data);
}

static inline void sendLED(uint8_t *p,DigitalOut& ws2811Data){
    sendLED(*p,*(p+1), *(p+2),ws2811Data);
}

void sendBuffer(uint8_t* rgbBuf,size_t len,DigitalOut& ws2812Data){
    __disable_irq();
    for(size_t i=0;i<len;i++){
        sendLED(rgbBuf+3*i,ws2812Data);
    }
    __enable_irq();
}