#include "ColorConversion.h"


/*
this function converts all len pixels from HSV colorspace to RGB colorspace. Value is constant and assumed to be the same for all pixels 
in hsBuf [HSHSHS...] All HSV values are integers, multiplied by a constant factor of 1000, so that integer math works (in case there's no
FPU).
*/
void convertHSVtoRGB(const int* hsBuf, uint8_t* rgbBuf,size_t len,int CVALUE){
    for(size_t i=0;i<len;i++){
        int hue = hsBuf[2*i];
        hue = hue%360000;
        int saturation = hsBuf[2*i+1];
        int c = CVALUE*saturation/1000;
        //float unused;
        int x = c * (1000-abs((hue/60)%2000-1000))/1000;
        int m = CVALUE-c;
        int rprime,gprime,bprime;
        if (0 <= hue && hue < 60000){
            rprime=c;
            gprime=x;
            bprime=0;
        }else if(60000 <= hue && hue < 120000){
            rprime=x;
            gprime=c;
            bprime=0;
        }else if(120000 <= hue && hue < 180000){
            rprime=0.0f;
            gprime=c;
            bprime=x;
        }else if(180000 <= hue && hue < 240000){
            rprime=0;
            gprime=x;
            bprime=c;
        }else if(240000 <= hue && hue < 300000){
            rprime=x;
            gprime=0;
            bprime=c;
        }else{// if(300f <= hue && hue < 360f){
            rprime=c;
            gprime=0;
            bprime=x;
        }
        rgbBuf[3*i]=uint8_t((rprime+m)*255/1000);
        rgbBuf[3*i+1]=uint8_t((gprime+m)*255/1000);
        rgbBuf[3*i+2]=uint8_t((bprime+m)*255/1000);
    }
}