#ifndef SERVO_GUI_H
#define SERVO_GUI_H
#include "LCD_DISCO_F429ZI.h"
#include "mbed.h"

#define DISK_X 120
#define DISK_Y 120
#define DISK_RADIUS 100
#define SMALL_DISK_RADIUS 20
#define MAX_STEPS 16
#define PI 3.14159
#define LED_X 30
#define LED_Y 290
#define LED_DISTANCE 60
#define LED_RADIUS 20
#define DELAY 0.25


enum eState {ON,OFF};
enum eDirection {LEFT,RIGHT};

struct Servo {
    unsigned int uiCurrentPosition;
    unsigned int uiDesiredPosition;
    unsigned int uiPreviousPosition;
};

class ServoGui{
    public:
        ServoGui();
        void ServoCallib();
        void ServoGoTo(uint8_t ui8Position);
        struct Servo sServo;
    private:
        LCD_DISCO_F429ZI lcd;
        uint8_t ui8ActualLedPoint;
        void DrawDisk();
        enum eState eLedStates[3];
        void LedOn(uint8_t ui8LedNumber);
        void DrawLed(uint8_t);
        enum eState eReadDetector();
        void LedStep(enum eDirection eWhere);      
};     




#endif
