#include "servo_gui.h"


DigitalIn MyCallibButton(USER_BUTTON);

ServoGui::ServoGui(){
    lcd.Clear(LCD_COLOR_WHITE);
    ui8ActualLedPoint = 0;
    DrawDisk();
    LedOn(0);
    
}

enum eState ServoGui::eReadDetector(){
    if(MyCallibButton == 1){
        return ON;
    }
    else {
        return OFF;
    }    
}    

void ServoGui::ServoCallib(){
    while(eReadDetector() == OFF){
        LedStep(RIGHT);
        wait(DELAY);    
    }
    sServo.uiCurrentPosition = ui8ActualLedPoint;
    sServo.uiDesiredPosition = ui8ActualLedPoint;
    
}

void ServoGui::ServoGoTo(uint8_t ui8Position){
  sServo.uiDesiredPosition = ui8Position;
  while(sServo.uiCurrentPosition != sServo.uiDesiredPosition){
      if(sServo.uiCurrentPosition < sServo.uiDesiredPosition){
            LedStep(LEFT);
            sServo.uiCurrentPosition++;
       }
       else if(sServo.uiCurrentPosition > sServo.uiDesiredPosition){
           LedStep(RIGHT);
           sServo.uiCurrentPosition--;   
       } 
       wait(DELAY);  
  }   
}

void ServoGui::DrawLed(uint8_t ui8LedNumber){
    
    if(ui8LedNumber <= 3){
        lcd.SetTextColor(LCD_COLOR_BLACK);
        lcd.DrawCircle(LED_X + LED_DISTANCE*ui8LedNumber,LED_Y,LED_RADIUS); 
    }
    if(eLedStates[ui8LedNumber] == ON){
        lcd.SetTextColor(LCD_COLOR_BLUE);
    }
    else{
        lcd.SetTextColor(LCD_COLOR_WHITE);
    }
    
    lcd.FillCircle(LED_X+LED_DISTANCE*ui8LedNumber,LED_Y ,LED_RADIUS-2);
}  


void ServoGui::LedOn(uint8_t ui8LedNumber){
      for(uint8_t ui8LedCounter = 0; ui8LedCounter <= 3; ui8LedCounter++){
            eLedStates[ui8LedCounter] = OFF;
            DrawLed(ui8LedCounter);
      }
          if(ui8LedNumber <= 3){
            eLedStates[ui8LedNumber] = ON;
            DrawLed(ui8LedNumber);
          }    
}  

void ServoGui::LedStep(enum eDirection eWhere){
    if(eWhere == RIGHT){
        ui8ActualLedPoint = ui8ActualLedPoint + 1;
    }
    else if(eWhere == LEFT){
        ui8ActualLedPoint = ui8ActualLedPoint - 1;
    }
    LedOn(ui8ActualLedPoint%4);
    DrawDisk();   
}

void ServoGui::DrawDisk(){
    double dAngleOfPointer = (ui8ActualLedPoint%MAX_STEPS);
    dAngleOfPointer = dAngleOfPointer/ MAX_STEPS;
    dAngleOfPointer = dAngleOfPointer * 2 * PI;
    
    lcd.SetTextColor(LCD_COLOR_BLACK);
    lcd.FillCircle(DISK_X,DISK_Y,DISK_RADIUS);
    lcd.SetTextColor(LCD_COLOR_WHITE);
    lcd.DrawLine(DISK_X,DISK_Y,DISK_X+(DISK_RADIUS * cos(dAngleOfPointer)), DISK_Y + (DISK_RADIUS * sin(dAngleOfPointer)));
    lcd.FillCircle(DISK_X,DISK_Y,SMALL_DISK_RADIUS);    
}    