#include "mbed.h"
#include "command_decoder.h"
#include "servo_gui.h"

#define CR '\r'

Serial MyUART(USBTX, USBRX,9600);
ServoGui MyServoGui;
CommandDecoder MyCommandDecoder;

uint8_t puts(char *cBufferTransmit, unsigned char ucBufferSize){
    unsigned char ucCharacterCounter;   
    
    for(ucCharacterCounter = 0; ucCharacterCounter <= ucBufferSize; ucCharacterCounter++){      
        if(cBufferTransmit[ucBufferSize] == NULL){
        break;
        }
    }       
    if(ucCharacterCounter == ucBufferSize){
        return 1;
    }
        
    for(unsigned char ucCharacterCounter = 0; cBufferTransmit[ucCharacterCounter] != NULL; ucCharacterCounter++){
        MyUART.putc(cBufferTransmit[ucCharacterCounter]); 
    }                              
    MyUART.putc(CR);           
    return 0;     
  } 
  
uint8_t gets(char *cBufferReceived, unsigned char ucBufferSize){
    unsigned char ucCharacterCounter = 0;
    
    while(ucCharacterCounter < ucBufferSize){
        cBufferReceived[ucCharacterCounter] = MyUART.getc(); 
        if(cBufferReceived[ucCharacterCounter] == CR){
           cBufferReceived[ucCharacterCounter] = NULL; 
           return 0;        
        }
        ucCharacterCounter++;
    }    
    return 1;
} 

void TokenHandling(){  
    char cID[] = "id_0x777";
    char cUnkownCommand[] = "unknowncommand";
    char cOK[] = "ok";
    
    if((MyCommandDecoder.ucTokenNr>0) && (MyCommandDecoder.asToken[0].eType == KEYWORD)){
       switch(MyCommandDecoder.asToken[0].uValue.eKeyword){
            case ID:
                puts(cID);
                break;
            case CALLIB:
                MyServoGui.ServoCallib();
                puts(cOK);
                break;
            case GOTO:
                if(MyCommandDecoder.asToken[1].eType == NUMBER){
                  MyServoGui.ServoGoTo(MyCommandDecoder.asToken[1].uValue.uiNumber);
                  MyServoGui.sServo.uiPreviousPosition = MyCommandDecoder.asToken[1].uValue.uiNumber;   
                  puts(cOK);                         
                }
                else{
                   puts(cUnkownCommand);
                }
                break;   
            case STEP:
                if(MyCommandDecoder.asToken[1].eType == NUMBER){
                  MyServoGui.ServoGoTo(MyServoGui.sServo.uiPreviousPosition + MyCommandDecoder.asToken[1].uValue.uiNumber);
                  MyServoGui.sServo.uiPreviousPosition = MyServoGui.sServo.uiPreviousPosition + MyCommandDecoder.asToken[1].uValue.uiNumber; 
                  puts(cOK); 
                }
                else{
                 puts(cUnkownCommand);
                }  
                break;
            default:
                puts(cUnkownCommand);
                break;                                                                   
        }
    }
    else {
        puts(cUnkownCommand,sizeof(cUnkownCommand));
    }       
}              

int main(){    
   char cUnkownCommand[] = "unkowncommand"; 
   char cBufferReceived[10];

    while(1){   
          
          if(gets(cBufferReceived,sizeof(cBufferReceived)) == 0){
              MyCommandDecoder.DecodeMsg(cBufferReceived);
              TokenHandling();
              
          }
          else{
              puts(cUnkownCommand,sizeof(cUnkownCommand));
          } 
                              
    }     
}


