#ifndef COMMAND_DECODER_H
#define COMMAND_DECODER_H
#include "mbed.h"
#include <string>

#define MAX_TOKEN_NR 2 
#define MAX_KEYWORD_STRING_LTH 6
#define MAX_KEYWORD_NR 4
#define DELIMITER_CHAR 0x20

enum TokenType { KEYWORD, NUMBER, STRING};
enum KeywordCode {ID,CALLIB,GOTO,STEP};
enum Result { OK, FAIL };


union TokenValue {
    enum KeywordCode eKeyword;
    unsigned int uiNumber;
    char *pcString;
};

struct Token {
    enum TokenType eType; 
    union TokenValue uValue;
};

struct Keyword {
    enum KeywordCode eCode;
    char cString[MAX_KEYWORD_STRING_LTH + 1]; 
};

class CommandDecoder {
    public:
        void DecodeMsg(char *pcString);
        struct Token asToken[MAX_TOKEN_NR];
        unsigned char ucTokenNr;
    private:
        enum Result eHexStringToUInt(char pcStr[],unsigned int *puiValue);
        void ReplaceCharactersInString(char pcString[], char cOldChar,char cNewChar);
        void TokenizeString(char *pcString);
        unsigned char ucFindTokensInString(char *pcString);
        enum Result eStringToKeyword(char pcStr[],enum KeywordCode *peKeywordCode);
        enum Result DecodeTokens();
       
};    

#endif