#include "command_decoder.h"
#include <string.h>
#include <iostream>
#include "mbed.h"

struct Keyword asKeywordList[MAX_KEYWORD_NR]=
    {
        {ID, "id"},
        {CALLIB, "callib"},
        {GOTO, "goto"},
        {STEP, "step"}
    };
struct Token asToken[MAX_TOKEN_NR];
enum State {TOKEN,DELIMITER};
unsigned char ucTokenNr = 0;

unsigned char CommandDecoder::ucFindTokensInString(char *pcString){
    char * pCurrentToken;
    unsigned char ucTokenCounter = 0;
    
    pCurrentToken = strtok(pcString, " ");
    while(NULL != pCurrentToken && ucTokenCounter < MAX_TOKEN_NR){
        asToken[ucTokenCounter].uValue.pcString = pCurrentToken;
        ucTokenCounter++;
        pCurrentToken = strtok(NULL, " ");
    }    
    return ucTokenCounter;
}


enum Result CommandDecoder::eStringToKeyword(char pcStr[],enum KeywordCode *peKeywordCode){
    unsigned char ucKeywordCounter;
    for(ucKeywordCounter=0;ucKeywordCounter<MAX_KEYWORD_NR;ucKeywordCounter++)
    {
        if (strcmp(pcStr,asKeywordList[ucKeywordCounter].cString) == 0)
        {
            *peKeywordCode = asKeywordList[ucKeywordCounter].eCode;
            return OK;
        }
    }
    return FAIL;
};


enum Result CommandDecoder::DecodeTokens(){
    
    unsigned int uiNumber;
    unsigned char ucTokenIndex;
    enum KeywordCode eKeyword;
    
    for(ucTokenIndex=0; ucTokenIndex < ucTokenNr; ucTokenIndex++){
        if((eStringToKeyword (asToken[ucTokenIndex].uValue.pcString, &eKeyword))== OK){
            asToken[ucTokenIndex].eType = KEYWORD;
            asToken[ucTokenIndex].uValue.eKeyword=eKeyword;
        }
        else if(sscanf(asToken[ucTokenIndex].uValue.pcString,"%x",&uiNumber) == 1){ 
            asToken[ucTokenIndex].eType = NUMBER;
            asToken[ucTokenIndex].uValue.uiNumber = uiNumber;       
        }
        else{
            asToken[ucTokenIndex].eType = STRING;
        }
    }
    return OK;
}


void CommandDecoder::ReplaceCharactersInString(char pcString[], char cOldChar,char cNewChar){
    char *pString = pcString;
    while((pString = strchr(pString,cOldChar)) != NULL){
        *pString++ = cNewChar;
    }    
}    


void CommandDecoder::DecodeMsg(char *pcString){
    ucTokenNr = ucFindTokensInString(pcString);
    ReplaceCharactersInString(pcString,' ', NULL);
    DecodeTokens();
}
