#include "led_lcd.h"
#include "mbed.h"
#include "LCD_DISCO_F429ZI.h"

LCD_DISCO_F429ZI lcd;

LedLcd::LedLcd(uint8_t WhichColumn){
    lcd.Clear(LCD_COLOR_BLACK);
    ui8Column = ((WhichColumn > 1) && (WhichColumn <= 3)) ? WhichColumn: 1;
      
};

void LedLcd::DrawLed(uint8_t ui8LedNumber, LedState eLedState){
     char cBuffer[2];
      
     lcd.SetTextColor(LCD_COLOR_GREEN);
     lcd.DrawRect(((ui8Column-1)*80),80*ui8LedNumber,80,80);
     
     if(eLedState == LED_PRESSED){
          lcd.SetTextColor(LCD_COLOR_GREEN); 
     }
    else if(eLedState == LED_RELEASED){
          lcd.SetTextColor(LCD_COLOR_BLUE); 
    }
    
     lcd.FillRect(((ui8Column-1)*80)+2,80*ui8LedNumber+2,77,77);
     
     BSP_LCD_SetFont(&Font24);
     lcd.SetBackColor(LCD_COLOR_RED);
     sprintf(cBuffer,"%d",ui8LedNumber);
     lcd.SetTextColor(LCD_COLOR_WHITE);   
     lcd.DisplayStringAt(((ui8Column-1)*80)+1,80*ui8LedNumber+1,(uint8_t *)&cBuffer,LEFT_MODE);
};     
        
/*void LedLcd::On(uint8_t ui8LedNumber){     
    
    for(uint8_t ui8LedCounter=0; ui8LedCounter<4; ui8LedCounter++){
            if(ui8LedCounter == ui8LedNumber){ 
                DrawLed(ui8LedCounter,LED_PRESSED);
            }
            else {
                DrawLed(ui8LedCounter,LED_RELEASED);
            }
    }*/
void LedLcd::On(uint8_t ui8LedNumber){ 

     for(uint8_t ui8LedCounter = 0; ui8LedCounter <= 3; ui8LedCounter++){
            DrawLed(ui8LedCounter, LED_RELEASED);
     } 
     DrawLed(ui8LedNumber,LED_PRESSED);                                                  
};  
