#include "keyboard_ts.h"
#include "TS_DISCO_F429ZI.h"

TS_DISCO_F429ZI ts;

KeyboardTs::KeyboardTs(uint8_t WhichColumn){
        ts.Init(240,320);
        ui8Column = ((WhichColumn > 1) && (WhichColumn <= 3)) ? WhichColumn: 1;
};
enum KeyboardState KeyboardTs::eRead(void){
        TS_StateTypeDef TS_State; 
        ts.GetState(&TS_State);
        
             if(TS_State.TouchDetected &&(TS_State.X > (80*(ui8Column-1))) && (TS_State.X<(80*ui8Column))){
                 if((TS_State.Y<80)){
                     return BUTTON_0;
                 }
                else if((TS_State.Y >= 80) && (TS_State.Y<160)){
                    return BUTTON_1;
                }
                else if((TS_State.Y >= 160)&& (TS_State.Y<240)){
                    return BUTTON_2;
                }
                else if((TS_State.Y >= 240)&& (TS_State.Y<320)){
                    return BUTTON_3; 
                }               
             }
             return RELEASED;
};