#include "mbed.h"
#include "ServoGUI.h"
#include "TokensHandling.h"

#define CR '\r'

Serial MySerialConnection(USBTX, USBRX, 9600);

int puts(char *pcCharsToSend, unsigned char ucNumberOfCharsToSend){
    unsigned char ucCurrentChar;
    
    for(ucCurrentChar=0; ucCurrentChar<ucNumberOfCharsToSend; ucCurrentChar++){
        if(pcCharsToSend[ucCurrentChar]==NULL) 
            break; 
        else if((ucCurrentChar==ucNumberOfCharsToSend)&&(pcCharsToSend[ucCurrentChar]!=NULL))
            return 1; 
        }
    
    for(ucCurrentChar=0; pcCharsToSend[ucCurrentChar]!=NULL; ucCurrentChar++){
        MySerialConnection.putc(pcCharsToSend[ucCurrentChar]);
        }
    
    MySerialConnection.putc(CR);
    return 0;
    }

int gets(char *pcGotCharDestination, unsigned char ucInputBufferSize){
    unsigned char ucCurrentRecivedChar=0;

        for(ucCurrentRecivedChar=0; ucCurrentRecivedChar<ucInputBufferSize; ucCurrentRecivedChar++){
            char cInputChar=MySerialConnection.getc();
            
            if(cInputChar == CR){
                pcGotCharDestination[ucCurrentRecivedChar]=NULL;
                return 0;
            }
            else {
                pcGotCharDestination[ucCurrentRecivedChar]=cInputChar;
            }
        } 
    pcGotCharDestination[--ucCurrentRecivedChar]=NULL;   
    return 1;
    }


int main(){
    ServoGUI MyServo;
    TokensHandler TokenDecoder;
    
    char cInputString[MAX_KEYWORD_STRING_LTH];
    char cErrorMessage[]="unknowncommand\n";
    char cBoardId[]="DISCO_F429ZI\n";
    char cOkMessage[]="OK\n";

    while(1){
        
        if(gets(cInputString, sizeof(cInputString))==0){
            TokenDecoder.DecodeMsg(cInputString);
            
            if((TokenDecoder.asToken[0].eType==KEYWORD)&&(TokenDecoder.ucTokenNr>0)){
                
                switch(TokenDecoder.asToken[0].uValue.eKeyword){            
                        case GOTO:    
                            if(TokenDecoder.asToken[1].eType==NUMBER){  
                                MyServo.GoTo(TokenDecoder.asToken[1].uValue.uiNumber);
                                puts(cOkMessage, (strlen(cOkMessage)+1));
                            }
                            break;
                        
                        case CALLIB:   
                            MyServo.Callib();
                            puts(cOkMessage, (strlen(cOkMessage)+1));
                            break;     
                        
                        case STEP:
                            if(TokenDecoder.asToken[1].eType==NUMBER){
                                MyServo.Shift(TokenDecoder.asToken[1].uValue.uiNumber);
                                puts(cOkMessage, (strlen(cOkMessage)+1));   
                            }
                            break;
                        
                        case ID:
                            puts(cBoardId, (strlen(cBoardId)+1));
                            break;
                        
                        default:
                            puts(cErrorMessage, (strlen(cErrorMessage)+1)); 
                            break;
                        }
                }
        else {
            puts(cErrorMessage, (strlen(cErrorMessage)+1));
        }
    }
} 
}
    
  
 


