#ifndef TOKENS_HANDLING_H
#define TOKENS_HANDLING_H

#define MAX_KEYWORD_STRING_LTH 15
#define MAX_TOKEN_NR 2

enum KeywordCode {CALLIB, GOTO, ID, STEP};
enum TokenType {KEYWORD, NUMBER, STRING};

union TokenValue{
    enum KeywordCode eKeyword;
    unsigned int uiNumber;
    char* pcString;
};

struct Token{
    enum TokenType eType;
    union TokenValue uValue;
};

class TokensHandler{
    private: 
        unsigned char ucFindTokensInString(char *pcString);
        enum Result eStringToKeyword (char pcStr[],enum KeywordCode *peKeywordCode);
        void DecodeTokens(void);
        void ReplaceCharactersInString(char pcString[],char cOldChar,char cNewChar);
    public:
        TokensHandler();
        unsigned char ucTokenNr;
        struct Token asToken[MAX_TOKEN_NR];
        void DecodeMsg(char *pcString);
};

#endif