#include "TokensHandling.h"
#include "mbed.h"

#define MAX_KEYWORD_NR 4

enum Result {OK, ERR};

struct Keyword{
    enum KeywordCode eCode;
    char cString[MAX_KEYWORD_STRING_LTH];
};

struct Keyword asKeywordList[MAX_KEYWORD_NR]={
    {CALLIB, "callib"},
    {GOTO,  "goto"},
    {ID,  "id"},
    {STEP,  "step"},
};

void TokensHandler::ReplaceCharactersInString(char pcString[],char cOldChar,char cNewChar){
    char *pString = pcString;
    while((pString = strchr(pString,cOldChar)) != NULL){
        *pString++ = cNewChar;
    }
}  


unsigned char TokensHandler::ucFindTokensInString(char *pcString){
    char *pcTokenString = pcString;
    pcTokenString = strtok(pcTokenString, " ");
    
    for(ucTokenNr=0;((pcTokenString != NULL) && (ucTokenNr < MAX_TOKEN_NR));ucTokenNr++)
    {      
            asToken[ucTokenNr].uValue.pcString = pcTokenString;
            pcTokenString = strtok(NULL, " ");
    }
    return ucTokenNr;
}



enum Result TokensHandler::eStringToKeyword (char pcStr[],enum KeywordCode *peKeywordCode){
    unsigned char ucKeywordCounter;

    for(ucKeywordCounter=0; ucKeywordCounter< MAX_KEYWORD_NR; ucKeywordCounter++){
        
        if( (strcmp(pcStr, asKeywordList[ucKeywordCounter].cString))==0){
            *peKeywordCode = asKeywordList[ucKeywordCounter].eCode;
            return OK;
        }
    }
    return ERR;
}

void TokensHandler::DecodeTokens(void){
    unsigned char ucTokenCounter;
    struct Token *psCurrentToken;
    unsigned int uiTokenValue;
    enum KeywordCode eTokenCode;

    for(ucTokenCounter= 0; ucTokenCounter< ucTokenNr; ucTokenCounter++){
        psCurrentToken= &asToken[ucTokenCounter];
        if(OK== eStringToKeyword(psCurrentToken->uValue.pcString, &eTokenCode)){
            psCurrentToken->eType=KEYWORD;
            psCurrentToken->uValue.eKeyword=eTokenCode;
        }
        else if(sscanf(asToken[ucTokenCounter].uValue.pcString, "%x", &uiTokenValue) == 1 ){
            psCurrentToken->eType= NUMBER;
            psCurrentToken->uValue.uiNumber= uiTokenValue;
        }
        else{
            psCurrentToken->eType=STRING;
        }
    }
}

void TokensHandler::DecodeMsg(char *pcString){
    ucTokenNr= ucFindTokensInString(pcString);
    ReplaceCharactersInString(pcString, ' ', NULL);
    DecodeTokens();
}

TokensHandler::TokensHandler(){
    ucTokenNr=0;    
}

