#ifndef SERVO_GUI
#define SERVO_GUI

#include "LCD_DISCO_F429ZI.h"

#define NUMBER_OF_LEDS 4


struct sPoint{double X; double Y;};

class ServoGUI{
    private:
        LCD_DISCO_F429ZI LCD_Display; 
        sPoint sPosition;
        unsigned char ucCurrentPosition;
        unsigned char ucStepPosition; 
        unsigned char ucCallibPosition;
        
        enum eDetectorState GetDetector();
        void MovePos(enum eStep eDirection);
        void DrawServo();
        void DrawLed(unsigned char ucCurrentLed=0,uint32_t uiLedColor=LCD_COLOR_WHITE);     
        void Step();
    public:
        ServoGUI();
        void LedOn(unsigned char ucLed=0);
        void GoTo(unsigned char ucPosition);
        void Shift(unsigned char ucLed=0);
        void Callib();
};

#endif