/*********************************************************************
サンプルアプリ４　センサー
新しいセンサーデバイスを発見すると、そのデバイスから照度と温度を得ます。
ここでは子機のXBeeセンサーにDigi純正のXBee Sensorを想定していますが、
自作したセンサーでもDIO1～2(XBee_pin 19～18)に0～1.2Vのアナログ電圧を
与えていれば、何らかの値を読みとることができます。

Sample Code 4 Sensor
Measured results of an XBee wireless sensor device are displayed a LCD
on Nucleo board with an XBee coordinator which is in API mode.
When you will use this anything other than Nucleo microcomputer board,
please change the 4th line of xbee/xbee.cpp:
        RawSerial _xbee_serial(SERIAL_TX, SERIAL_RX);

新しいXBee子機のコミッションボタンDIO0(XBee_pin 20)を押下する(信号レベ
ルがH→L→Hに推移する)と、子機から参加要求信号が発行されて、Arduino親機
が子機を発見し、「found a device」と表示します。

ただし、複数のZigBeeネットワークに対応するために、ペアリングは起動後の
30秒間しか受け付けません。Arduino親機を起動して、コミッションボタンを
押してペアリングを実施しておき、再度、コミッションボタンでデバイス発見
します。デバイス発見は30秒のペアリング期間後でも行えます。

本ソースリストおよびソフトウェアは、ライセンスフリーです。
利用、編集、再配布等が自由に行えますが、著作権表示の改変は禁止します。

解説：
http://www.geocities.jp/bokunimowakaru/diy/xbee/xbee-nucleo.html

                               Copyright (c) 2010-2014 Wataru KUNINO
                               http://www.geocities.jp/bokunimowakaru/
*********************************************************************/
#include <mbed.h>
#include "xbee.h"
#include "TextLCD.h"
#define FORCE_INTERVAL  100				// 1～254 データ要求間隔
TextLCD lcd(PA_9, PC_7, PB_5, PB_4, PB_10, PA_8); // rs, e, d4-d7
byte dev_sens[8];	// IEEE Address

int main(){
	int i;
	int dev_en = 0;						// センサー発見の有無(0:未発見)
	XBEE_RESULT xbee_result;			// 受信データ用の構造体
	int trig=0;
	float value;

	lcd.cls(); lcd.printf("Sample 4 SENS");
	xbee_init( 0x00 );					// XBee用COMポートの初期化(引数はポート番号)
	// デバイス探索
	lcd.cls(); lcd.printf("Searching:SENSOR");
	if( xbee_atnj(10) ){				// 10秒間の参加受け入れ
		lcd.cls(); lcd.printf("Found a device");
		xbee_from( dev_sens );			// 受信したアドレスをdev_sensへ格納
		dev_en = 1;						// sensor発見済
		xbee_gpio_config( dev_sens, 1 , AIN ); // 接続相手のポート1をAIN入力へ
		xbee_gpio_config( dev_sens, 2 , AIN ); // 接続相手のポート2をAIN入力へ
	}else{
		lcd.cls(); lcd.printf("Failed:no dev.");
	}
	wait(1);
	lcd.cls();
	
	// メイン処理
	while(1){							// 永久に受信する
		if(dev_en){	
			if(trig<=0){
				lcd.locate(12,0); lcd.printf("Trig"); wait(0.1);
				xbee_force(dev_sens);	// デバイスdev_sensへデータ要求
				trig = FORCE_INTERVAL;
				lcd.locate(12,0); lcd.printf("    ");
			}
		}else{
			lcd.cls(); lcd.printf("Waiting for XBee");
			wait(0.5);
			lcd.cls();
		}
		trig--;

		/* データ受信(待ち受けて受信する) */
		xbee_rx_call( &xbee_result );	// データを受信します。
		switch( xbee_result.MODE ){		// 受信したデータの内容(MODE値)に応じて
			case MODE_RESP:				// sensorからの応答の場合に照度と温度を表示
			case MODE_GPIN:				// 周期方式でデータ受信した場合も想定
				if( bytecmp( dev_sens , &(xbee_result.FROM[0]) ,8 ) == 0 && xbee_result.STATUS == STATUS_OK ){
					// 照度測定結果
					value = xbee_sensor_result( &xbee_result, LIGHT);
					lcd.locate(0,0); lcd.printf( "%.1f Lux   ",value);
					// 温度測定結果
					value = xbee_sensor_result( &xbee_result, TEMP);
					lcd.locate(0,1); lcd.printf( "%.1f C   ",value);
				}
				break;
			case MODE_IDNT:				// 新しいデバイスを発見
				lcd.cls(); lcd.printf("found a new dev");
				for( i=0;i<8;i++ ) dev_sens[i]=xbee_result.FROM[i];
										// 発見したアドレスをdev_sensに読み込み
				dev_en = 1;				// sensor発見済
				trig = 0;
				xbee_gpio_config( dev_sens, 1 , AIN ); // 接続相手のポート1をAIN入力へ
				xbee_gpio_config( dev_sens, 2 , AIN ); // 接続相手のポート2をAIN入力へ
				lcd.cls();
				break;
			default:
				break;
		}
	}
}
