/*********************************************************************
サンプルアプリ２　スイッチ
子機のスイッチ2～4(Port1～3)を押した時に、その状態を液晶に表示します。
XBee子機のDIO1～3(XBee_pin 19～17)をHigh や Low にすると PCまたはH8の
親機にスイッチの状態が表示されます。

Sample Code 2 Switch
To push buttons on an XBee ZB device report the conditions of input
ports on it to a Nucleo board, and display them on a LCD.
When you will use this anything other than Nucleo microcomputer board,
please change the 4th line of xbee/xbee.cpp:
RawSerial _xbee_serial(SERIAL_TX, SERIAL_RX);
        
本ソースリストおよびソフトウェアは、ライセンスフリーです。
利用、編集、再配布等が自由に行えますが、著作権表示の改変は禁止します。

                               Copyright (c) 2010-2014 Wataru KUNINO
                               http://www.geocities.jp/bokunimowakaru/
*********************************************************************/
/*
    port:   port指定  IO名 ピン番号           USB評価ボード(XBIB-U-Dev)
            port=11     DIO11   XBee_pin  7     LED2    ※port11がLED2
            port=12     DIO12   XBee_pin  4     LED1    ※port12がLED1
*/
#include "xbee.h"
#include "TextLCD.h"
TextLCD lcd(PA_9, PC_7, PB_5, PB_4, PB_10, PA_8); // rs, e, d4-d7


int main(){
    byte data;
    int i;
    XBEE_RESULT xbee_result;
    // お手持ちのXBee子機(リモート先)アドレスに変更して下さい ↓
    byte dev_gpio[]   = {0x00,0x13,0xA2,0x00,0x40,0x30,0xC1,0x6F};
    
    // 初期化処理
    lcd.cls(); lcd.printf("Sample 2 SW");
    xbee_init( 0x00 );                  // XBee用COMポートの初期化(引数はポート番号)
    lcd.cls(); lcd.printf("ATNJ");
    xbee_atnj( 0xFF );                  // デバイスを常に参加受け入れ(テスト用)
    lcd.cls(); lcd.printf("gpio init");
    xbee_gpio_init(dev_gpio);           // デバイスdev_gpioにIO設定を行うための送信
    lcd.cls(); lcd.printf("DONE");
    
    // メイン処理
    while(1){                           // 永久に受信する
        /* データ受信(待ち受けて受信する) */
        data = xbee_rx_call( &xbee_result );
                                        // データを受信します。
                                        // data：受信結果が代入されます
        if( xbee_result.MODE == MODE_GPIN){     // PIO入力(リモート機のボタンが押された)の時
            lcd.cls();
            for( i=7; i>=0 ; i--) lcd.printf( "%c",(char)( (int)'0' + ((data>>i) & 0x01) ) );
                                        // dataに入った値をバイナリで表示
        }
    }
}
