/*********************************************************************
サンプルアプリ１　リモート先のLEDをON/OFFする。

Sample Code 1 LED
An XBee ZB Coordinator on a Nucleo Board controls LEDs on the other
XBee ZB device.
When you will use this anything other than Nucleo microcomputer board,
please change the 4th line of xbee/xbee.cpp:
RawSerial _xbee_serial(SERIAL_TX, SERIAL_RX);

本ソースリストおよびソフトウェアは、ライセンスフリーです。
利用、編集、再配布等が自由に行えますが、著作権表示の改変は禁止します。

                               Copyright (c) 2010-2014 Wataru KUNINO
                               http://www.geocities.jp/bokunimowakaru/
*********************************************************************/
/*
    port:   port指定  IO名 ピン番号           USB評価ボード(XBIB-U-Dev)
            port=11     DIO11   XBee_pin  7     LED2    ※port11がLED2
            port=12     DIO12   XBee_pin  4     LED1    ※port12がLED1
*/
#include "xbee.h"
DigitalOut myled(LED1);

int main(){
    // お手持ちのXBee子機(リモート先)アドレスに変更して下さい ↓
    // Please set MAC Address to access your remote XBee device.
    byte dev_gpio[]   = {0x00,0x13,0xA2,0x00,0x40,0x30,0xC1,0x6F};
    
    myled = 1;                          // NUCLEOのLEDをHレベル(3.3V)へ
    xbee_init( 0 );                     // XBee用COMポートの初期化
    xbee_atnj( 0xFF );                  // デバイスの参加を受け入れる
    myled = 0;                          // NUCLEOのLEDをHレベル(3.3V)へ
    
    while(1){                           // 永久に受信する
        myled = 1;                      // NUCLEOのLEDをHレベル(3.3V)へ
        xbee_gpo(dev_gpio,11,1);        // GPOポート11をHレベル(3.3V)へ
        xbee_gpo(dev_gpio,12,1);        // GPOポート12をHレベル(3.3V)へ
        wait(1);
        myled = 0;                      // NUCLEOのLEDをHレベル(3.3V)へ
        xbee_gpo(dev_gpio,11,0);        // GPOポート11をLレベル(0.0V)へ
        xbee_gpo(dev_gpio,12,0);        // GPOポート12をLレベル(0.0V)へ
        wait(1);
    }
}
