/* YW51 module Library
 *
 * Copyright (c) 2019, 黃博鈞, National Taiwan University
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
 
 /*Example:
#include "mbed.h"
#include "YW51.h"
#include <string>
Serial pc(USBTX, USBRX);

YW51 dev(D2, 2400);
int main(){
    pc.baud(9600);
    int err;
    pc.printf("YW-51 Testing Program!\r\n");
    pc.printf("---------------------------\r\n");
    while(1){
        err = dev.readData();
        if(err == 0){
            pc.printf("PM2.5 = %fug/m3 \r\n", dev.ShowPM());
            //pc.printf("%d", dev.PMStage(dev.ShowPM()));
            }else{
                pc.printf("Data Error!\r\n");
            }
        pc.printf("----------------------------\r\n");
        }   
}
 */
#include "mbed.h"
#include "SoftSerial.h"//Software Serial implemented by Erik Oliman

#ifndef MBED_YW51_H
#define MBED_YW51_H

class YW51
{

public:
    YW51(PinName _rx, int Baud);
    int readData();
    double ShowPM();
    int PMStage(double pm);


private:
    SoftSerial _YW51;
    int msg[6];
    double pm;
    int findK(double vo);
    void getline();
};

#endif