/* YW51 module Library
 *
 * Copyright (c) 2019, 黃博鈞, National Taiwan University
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
#include "YW51.h"

YW51::YW51(PinName rx, int Baud) : _YW51(NC, rx)
{
    _YW51.baud(Baud);
}

int YW51::readData()
{
    double vo;
    getline();
    if(msg[0]+ msg[1]+ msg[2]+ msg[3] == msg[4]) {
        vo = (msg[0] * 256.0 + msg[1])* 2.5 / 1024.0;
        pm = findK(vo) * vo;
        return 0;
    } else {
        return 1;
    }
}

double YW51::ShowPM()
{
    return pm;

}
int YW51::findK(double vo)
{
    if(vo <= 0.045) {
        return 200;
    } else if(vo > 0.046 && vo < 0.048) {
        return 400;
    } else if(vo > 0.049 && vo < 0.051) {
        return 600;
    } else if(vo > 0.052 && vo < 0.054) {
        return 750;
    } else if(vo > 0.055 && vo < 0.058) {
        return 900;
    } else if(vo > 0.059 && vo < 0.064) {
        return 1000;
    } else if(vo > 0.065 && vo < 0.070) {
        return 1250;
    } else if(vo > 0.071 && vo < 0.075) {
        return 1400;
    } else if(vo > 0.076 && vo < 0.080) {
        return 1700;
    } else if(vo > 0.081 && vo < 0.085) {
        return 1800;
    } else if(vo > 0.086 && vo < 0.090) {
        return 1900;
    } else if(vo > 0.091 && vo < 0.100) {
        return 2000;
    } else if(vo > 0.101 && vo < 0.110) {
        return 2200;
    } else if(vo >= 0.111) {
        return 3000;
    }
}
int YW51::PMStage(double pm)
{
    if(pm <= 35) {
        return 1;//good
    } else if(pm > 35 && pm <= 53 ) {
        return 2; //medium
    } else if(pm > 53 && pm <= 70 ) {
        return 3;//bad
    } else {
        return 4;//very bad
    }
}
void YW51::getline()
{
    while(_YW51.getc() != 170);    // wait for the start of a line
    for(int i = 0; i < 6; i++) {
        msg[i] = _YW51.getc();
        if(msg[i] == 255) {
            return;
        }
    }
    error("Overflowed message limit");
}

