#include "mbed.h"
#include "LCD_DISCO_F746NG.h"
#include "stdio.h"
#include "DHT.h"


#define On 1
#define Off 0

/*====================================================================================================================================================*/

LCD_DISCO_F746NG lcd;

Serial pc(USBTX, USBRX);

DHT sensor(D0,DHT11);

AnalogIn analogValue(A1);


/*====================================================================================================================================================*/
 
 
 void analogConnexionTest(double t, double sm, double am, int* pinState)
{
    float seuil = 0.1;
    
    if(t<seuil){
     pinState[0]=1;
    }
    else{
     pinState[0]=1;
    }    
         
    if(sm<seuil){
        pinState[1]=1;
    }
    else{
        pinState[1]=1;
        }
        
    if(am<seuil){
        pinState[2]=1;
        }
    else{
        pinState[2]=1;   
        
    }
}



/*int wateringActivation(double t, double sm, double am)
{
    
    if(sm<0.3 && am <0.3)
    {
        engineControl(On);
        return 1;
    }   
    
    else return 0;
    
    
}*/


/*void engineControl(int State)
{
    
    
    
    
    
}*/









int main()
{
    
//Initialisation variables
    
    //Variable de lecture des taux d'humidité sol/air et température
    int error;
    
    pc.printf("Salut");
    
    float mesTemperature;
    float mesSoilMoisture;
    float mesAirMoisture;
    
    //Variable d'affichage taux d'humidité sol/air et température
    
    char afficheT[50];
    char afficheSM[50];
    char afficheAM[50];
    
    //Variable État des pins
    
    int pinState[3];
    
    //Variable Arrosage
    
    /*int stateWatering = 0;
    int wateringCooldown = 60;
    int wateringDuration = 10;*/
    

    
//Initialisation Écran
    
    lcd.Init();
    lcd.Clear(LCD_COLOR_BLACK);
    lcd.SetBackColor(LCD_COLOR_BLACK);
    lcd.SetTextColor(LCD_COLOR_WHITE);
    lcd.DisplayStringAt(0,116, (uint8_t*) "PROJET SER1 - v1.0",CENTER_MODE);
    wait(2);
    
    
//Boucle événementielle
    
    while(true) {
        
        error = sensor.readData();
        
        //Affichage État du système
    
        lcd.Clear(LCD_COLOR_WHITE);
        
        analogConnexionTest(mesTemperature, mesSoilMoisture, mesAirMoisture, pinState); //Test de connextion des pins
        
        mesTemperature = sensor.ReadTemperature(CELCIUS);
        mesSoilMoisture = analogValue.read();
        mesAirMoisture = sensor.ReadHumidity();
        
        if(pinState[0]+pinState[1]+pinState[2]==3){
                
                lcd.SetTextColor(LCD_COLOR_GREEN);
                lcd.SetFont(&Font16);
                lcd.SetBackColor(LCD_COLOR_WHITE);
                lcd.DisplayStringAt(100,20,(uint8_t*) "State: System on",CENTER_MODE);
                
        }
        
        else{
                lcd.SetTextColor(LCD_COLOR_RED);
                lcd.SetFont(&Font16);
                lcd.SetBackColor(LCD_COLOR_WHITE);
                lcd.DisplayStringAt(100,20,(uint8_t*) "State : System off",CENTER_MODE);
                
        }
        
        
        lcd.FillRect(0,0,10,272);
        lcd.FillRect(0,0,480,10);
        lcd.FillRect(0,262,480,10);
        lcd.FillRect(470,0,10,272);
        lcd.SetFont(&Font16);
        
        lcd.SetBackColor(LCD_COLOR_WHITE);
        lcd.SetTextColor(LCD_COLOR_BLACK);
        lcd.DisplayStringAt(15,20, (uint8_t*) "Temperature",LEFT_MODE);
        lcd.DisplayStringAt(15,96, (uint8_t*) "Soil moisture",LEFT_MODE);
        lcd.DisplayStringAt(15,177, (uint8_t*) "Air moisture",LEFT_MODE);
        
        
        if(pinState[0] == 0){
             lcd.SetTextColor(LCD_COLOR_RED);
             lcd.DisplayStringAt(15,50, (uint8_t*) "Disconnected", LEFT_MODE);
             }       
        else{
         lcd.SetTextColor(LCD_COLOR_BLACK);
         sprintf(afficheT,"%f",mesTemperature);
         lcd.DisplayStringAt(15,50,(uint8_t*) afficheT, LEFT_MODE);
             }
    
        if(pinState[1] == 0){
             lcd.SetTextColor(LCD_COLOR_RED);
             lcd.DisplayStringAt(15,126, (uint8_t*) "Disconnected", LEFT_MODE);
             }       
        else{
         lcd.SetTextColor(LCD_COLOR_BLACK);
         sprintf(afficheSM,"%d",error);
         lcd.DisplayStringAt(15,126,(uint8_t*) afficheSM, LEFT_MODE);
             }
        
        if(pinState[2] == 0){
             lcd.SetTextColor(LCD_COLOR_RED);
             lcd.DisplayStringAt(15,207, (uint8_t*) "Disconnected", LEFT_MODE);
             }       
        else{
         lcd.SetTextColor(LCD_COLOR_BLACK);
         sprintf(afficheAM,"%f",mesAirMoisture);
         lcd.DisplayStringAt(15,207,(uint8_t*) afficheAM, LEFT_MODE);
             }
                              
             
       /* if(wateringCooldown == 60) wateringState = wateringActivation(mesTemperature,mesSoilMoisture,mesAirMoisture);
        
        else
        {           
            wateringCooldown -= 1;
                    
            if(wateringState == 1)
            {
                wateringDuration -= 1;                
                if(wateringDuration == 0)
                {
                    wateringState = 0;
                    engineControl(Off);
                } 
            }
            
            if(wateringCooldown == 0) wateringCooldown = 60;                       
        }    */
        
        
        wait(1);
    
    }      
}
 

