#ifndef _register_values_H_
#define _register_values_H_


typedef enum {  LDC_MODE_ACTIVE   = 0, \
                LDC_MODE_SLEEP    = 1, \
                LDC_MODE_SHUTDOWN = 2} LDC_MODE;

typedef enum {  DEGLITCH_1M  = 1, \
                DEGLITCH_3M  = 4, \
                DEGLITCH_10M = 5, \
                DEGLITCH_33M = 7} DEGLITCHER;     // This should be 011 (p. 16) or 111 (p.32)

typedef enum {  DATA_MSB_CH0        = 0x00, \
                DATA_LSB_CH0        = 0x01, \
                DATA_MSB_CH1        = 0x02, \
                DATA_LSB_CH1        = 0x03, \
                DATA_MSB_CH2        = 0x04, \
                DATA_LSB_CH2        = 0x05, \
                DATA_MSB_CH3        = 0x06, \
                DATA_LSB_CH3        = 0x07, \
                RCOUNT_CH0          = 0x08, \
                RCOUNT_CH1          = 0x09, \
                RCOUNT_CH2          = 0x0A, \
                RCOUNT_CH3          = 0x0B, \
                OFFSET_CH0          = 0x0C, \
                OFFSET_CH1          = 0x0D, \
                OFFSET_CH2          = 0x0E, \
                OFFSET_CH3          = 0x0F, \
                SETTLECOUNT_CH0     = 0x10, \
                SETTLECOUNT_CH1     = 0x11, \
                SETTLECOUNT_CH2     = 0x12, \
                SETTLECOUNT_CH3     = 0x13, \
                CLOCK_DIVIDERS_CH0  = 0x14, \
                CLOCK_DIVIDERS_CH1  = 0x15, \
                CLOCK_DIVIDERS_CH2  = 0x16, \
                CLOCK_DIVIDERS_CH3  = 0x17, \
                STATUS              = 0x18, \
                ERROR_CONFIG        = 0x19, \
                CONFIG              = 0x1A, \
                MUX_CONFIG          = 0x1B, \
                DRIVE_CURRENT_CH0   = 0x1E, \
                DRIVE_CURRENT_CH1   = 0x1F, \
                DRIVE_CURRENT_CH2   = 0x20, \
                DRIVE_CURRENT_CH3   = 0x21, \
                MANUFACTURER_ID     = 0x7E, \
                DEVICE_ID           = 0x7F} ADDR;

typedef enum {  CHx_ERR_UR          = 15, \
                CHx_ERR_OR          = 14, \
                CHx_ERR_WD          = 13, \
                CHx_ERR_AE          = 12, \
                ERR_CHAN            = 14, \
                ERR_UR              = 13, \
                ERR_OR              = 12, \
                ERR_WD              = 11, \
                ERR_AHE             = 10, \
                ERR_ALE             =  9, \
                ERR_ZC              =  8, \
                DRDY                =  6, \
                CH0_UNREADCONV      =  3, \
                CH1_UNREADCONV      =  2, \
                CH2_UNREADCONV      =  1, \
                CH3_UNREADCONV      =  0, \
                UR_ERR2OUT          = 15, \
                OR_ERR2OUT          = 14, \
                WD_ERR2OUT          = 13, \
                AH_ERR2OUT          = 12, \
                AL_ERR2OUT          = 11, \
                UR_ERR2INT          =  7, \
                OR_ERR2INT          =  6, \
                WD_ERR2INT          =  5, \
                AH_ERR2INT          =  4, \
                AL_ERR2INT          =  3, \
                ZC_ERR2INT          =  2, \
                DRDY_2INT           =  0, \
                ACTIVE_CHAN         = 14, \
                SLEEP_MODE_EN       = 13, \
                RP_OVERRIDE_EN      = 12, \
                SENSOR_ACTIVATE_SEL = 11, \
                AUTO_AMP_DIS        = 10, \
                REF_CLK_SRC         =  9, \
                INTB_DIS            =  7, \
                HIGH_CURRENT_DRV    =  6, \
                AUTOSCAN_EN         = 15, \
                RR_SEQUENCE         = 13, \
                DEGLITCH            = 0,  \
                CHx_INIT_IDRIVE     = 6,  \
                CHx_IDRIVE          = 11, \
                CHx_FIN_DIVIDER     = 12, \
                CHx_FREF_DIVIDER    = 0} SETTING;
                
#endif