#ifndef _DS1825_H
#define _DS1825_H

/**
* @file DS1825.h
* @brief this header file will contain all required
* definitions for the functions to interface with the DS1825.
*
* @author Bob Giesberts
*
* @date 2016-03-23
*/

#include "mbed.h"
#include "mbed_debug.h"
#include "OneWire.h"


class DS1825 {
    public:
        DS1825(PinName pin);
        ~DS1825();
        float getTemperature(void);
        OneWire *_onewire;
        float T;

    private:
        bool validateTemperature(uint8_t data[9]);
        void convertTemperature( void );
        
        uint32_t lastconversion;

};

#endif