#include "DS1825.h"

//DS1825::DS1825( PinName pin ) : _onewire( pin )
DS1825::DS1825( PinName pin )
{   
    T = 0;
    _onewire = new OneWire( pin ); 
    wait_ms(100);   
    convertTemperature();
}

DS1825::~DS1825( )
{   
    _onewire->depower();
    delete _onewire;
    _onewire = NULL;
}

bool DS1825::validateTemperature( uint8_t d[9] )
{
    return (d[8] == _onewire->crc8(d, 8));     
}

void DS1825::convertTemperature( void )
{
    // in 12-bit mode, this takes 750 ms
    _onewire->reset();
    _onewire->skip();                // Skip ROM  --> because there is only one sensor, no need to search for the correct ID
    _onewire->write( 0x44, 1 );      // Convert T --> initiate temperature conversion, data is stored on scratchpad, after writing put the wire high to power the DS1825
    lastconversion = (uint32_t) clock();
}

float DS1825::getTemperature( void )
{     
    // If the thermometer is not read (it takes 750 ms), 
    // just send the previous value.
    // Don't interupt the conversion!
    if ( clock() - lastconversion  < 750 / 10 )
        return T;

    // Send command to read the data 
    _onewire->reset();
    _onewire->skip();                // Skip ROM
    _onewire->write( 0xBE );         // Command to read scratchpad
    
    // Read the data
    uint8_t Tdata[9];
    for (int i = 0; i < 9; i++) 
        Tdata[i] = _onewire->read(); // read scratchpad    
    _onewire->depower();
    
    // Send the command to start calculating the new temperature
    convertTemperature();
    
    // validate the result
    if( validateTemperature( Tdata ) )
    {
        int16_t T_bin = (Tdata[1] << 8) | Tdata[0];
        T = T_bin / 16.0;
        return T;
    }
    return 0;
}
